/*
 * Decompiled with CFR 0.152.
 */
package com.pme.control;

import Plot.ElectricalCurrents;
import Plot.EnergyConsumption;
import Plot.MiscParam;
import Plot.OperationTimes;
import com.pme.control.Concatenate;
import com.pme.control.Main;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.jfree.ui.RefineryUtilities;

public class MainJFrame
extends JFrame {
    private ButtonGroup buttonGroup1;
    private JFileChooser dataFileChooser;
    private JButton jImportButton;
    private JLabel jImportLabel;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JButton jProcessButton;
    private JProgressBar jProgressBar;

    public MainJFrame() {
        int i;
        this.initComponents();
        this.getContentPane().setBackground(Color.white);
        this.setTitle("miniWiper Plot Rev " + Main.Revision);
        String workingFolder = System.getProperty("user.dir");
        System.out.println("Working directory: " + workingFolder);
        File measurementsFolder = new File(workingFolder);
        String[] measurementFilesAndMaybeOthers = measurementsFolder.list();
        for (i = 0; i < measurementFilesAndMaybeOthers.length && !measurementFilesAndMaybeOthers[i].contains("5958-"); ++i) {
        }
        if (i < measurementFilesAndMaybeOthers.length) {
            this.jImportLabel.setText(workingFolder + File.separatorChar + measurementFilesAndMaybeOthers[i]);
            this.jProcessButton.setEnabled(true);
        } else {
            this.jImportLabel.setText("none selected");
            this.jProcessButton.setEnabled(false);
        }
    }

    private void initComponents() {
        this.dataFileChooser = new JFileChooser();
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jImportButton = new JButton();
        this.jImportLabel = new JLabel();
        this.jProcessButton = new JButton();
        this.jProgressBar = new JProgressBar();
        this.setDefaultCloseOperation(3);
        this.setBackground(new Color(255, 255, 255));
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/com/pme/resources/PME logo.jpg")));
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Plot"));
        this.jImportButton.setText("Select DATA Folder");
        this.jImportButton.setToolTipText("Select 'Data' folder containing C7 Logger files.");
        this.jImportButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainJFrame.this.jImportButtonActionPerformed(evt);
            }
        });
        this.jImportLabel.setText("(none selected)");
        this.jImportLabel.setToolTipText("The location of C7 Logger files.");
        this.jProcessButton.setText("Plot");
        this.jProcessButton.setToolTipText("Read files, create plot");
        this.jProcessButton.setEnabled(false);
        this.jProcessButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainJFrame.this.jProcessButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jImportButton).addComponent(this.jProcessButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jProgressBar, -2, 218, -2).addComponent(this.jImportLabel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE))));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jImportButton).addComponent(this.jImportLabel, -2, 19, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jProcessButton).addComponent(this.jProgressBar, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1, -2, 376, -2).addGap(0, 114, Short.MAX_VALUE)).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(7, 7, 7).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jImportButtonActionPerformed(ActionEvent evt) {
        this.dataFileChooser.setFileSelectionMode(1);
        this.dataFileChooser.setDialogTitle("Select miniWiper DATA folder");
        int returnVal = this.dataFileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            File file = this.dataFileChooser.getSelectedFile();
            File d = this.dataFileChooser.getCurrentDirectory();
            this.jImportLabel.setText(d.getPath() + File.separatorChar + file.getName());
            this.jProcessButton.setEnabled(true);
        }
        if (returnVal == 1) {
            this.jImportLabel.setText("(canceled)");
            this.jProcessButton.setEnabled(false);
        }
    }

    private void jProcessButtonActionPerformed(ActionEvent evt) {
        final MainJFrame mjf = this;
        double[] C = new double[2];
        this.jProcessButton.setEnabled(false);
        Runnable myRunnable = new Runnable(){

            public void run() {
                Concatenate myc = new Concatenate(MainJFrame.this.jProgressBar, MainJFrame.this.jImportLabel.getText());
                try {
                    myc.Concatenate();
                }
                catch (IOException e) {
                    System.out.println("IOException: " + e);
                    JOptionPane.showMessageDialog(mjf, "IOException: " + e, "miniWiper Plot Error", 0);
                    System.exit(0);
                }
                catch (NumberFormatException n) {
                    System.out.println("Number format error " + n);
                    JOptionPane.showMessageDialog(mjf, "Number Format Error: " + n, "miniWiper Plot Error", 0);
                    System.exit(0);
                }
                try {
                    ElectricalCurrents demo = new ElectricalCurrents(MainJFrame.this.jProgressBar, "miniWiper Electrical Currents", myc);
                    demo.pack();
                    RefineryUtilities.centerFrameOnScreen(demo);
                    demo.setVisible(true);
                    MiscParam demo1 = new MiscParam(MainJFrame.this.jProgressBar, "miniWiper Misc Parameters", myc);
                    demo1.pack();
                    RefineryUtilities.centerFrameOnScreen(demo1);
                    demo1.setVisible(true);
                    OperationTimes demo2 = new OperationTimes(MainJFrame.this.jProgressBar, "miniWiper Operation Times", myc);
                    demo2.pack();
                    RefineryUtilities.centerFrameOnScreen(demo2);
                    demo2.setVisible(true);
                    EnergyConsumption demo3 = new EnergyConsumption(MainJFrame.this.jProgressBar, "miniWiper Energy Consumption", myc);
                    demo3.pack();
                    RefineryUtilities.centerFrameOnScreen(demo3);
                    demo3.setVisible(true);
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(mjf, "CatPlot I/O error: " + e, "miniWiper Plot Error", 0);
                    System.out.println("CatPlot error: " + e);
                    System.exit(0);
                }
                Runnable dorun = new Runnable(){

                    public void run() {
                        MainJFrame.this.jProcessButton.setEnabled(true);
                    }
                };
                try {
                    SwingUtilities.invokeLater(dorun);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        Thread thread = new Thread(myRunnable);
        thread.start();
    }
}

