/*
 * Decompiled with CFR 0.152.
 */
package com.pme.control;

import com.pme.io.MeasurementFile;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimeSeries;

public class Concatenate {
    public String SN = null;
    public int scrub = 0;
    public int angle = 0;
    public final int fullwipeangle = 240;
    public final double motorvoltage = 5.0;
    private final String measurementsPath;
    private final JProgressBar mpb;
    public TimeSeries battery = null;
    public TimeSeries temperature = null;
    public TimeSeries Wipes = null;
    public TimeSeries CalWipeTime = null;
    public TimeSeries WipeTime = null;
    public TimeSeries StartCurrent = null;
    public TimeSeries AverageCurrent = null;
    public TimeSeries PeakCurrent = null;
    public TimeSeries FinalCurrent = null;
    public TimeSeries RSource = null;
    public TimeSeries Energy = null;

    public Concatenate(JProgressBar mpb, String measurementsPath) {
        this.measurementsPath = measurementsPath;
        this.mpb = mpb;
    }

    public void Concatenate() throws IOException, NumberFormatException {
        int i;
        MeasurementFile measurementFile = null;
        File measurementsFolder = new File(this.measurementsPath);
        String[] measurementFilesAndMaybeOthers = measurementsFolder.list();
        if (measurementFilesAndMaybeOthers == null) {
            throw new IOException("Folder is empty");
        }
        int j = 0;
        for (i = 0; i < measurementFilesAndMaybeOthers.length; ++i) {
            if (!this.isMeasurementFile(measurementFilesAndMaybeOthers[i])) continue;
            ++j;
        }
        if (j == 0) {
            IOException mye = new IOException("No miniWiper .TXT files found");
            throw mye;
        }
        Object[] measurementFileNames = new String[j];
        j = 0;
        for (i = 0; i < measurementFilesAndMaybeOthers.length; ++i) {
            if (!this.isMeasurementFile(measurementFilesAndMaybeOthers[i])) continue;
            measurementFileNames[j] = measurementFilesAndMaybeOthers[i];
            ++j;
        }
        measurementFilesAndMaybeOthers = null;
        Arrays.sort(measurementFileNames);
        for (int fileindex = 0; fileindex < measurementFileNames.length; ++fileindex) {
            try {
                this.updateProgress((int)(100.0 * (double)fileindex / (double)measurementFileNames.length));
                System.out.println("processing file: " + (String)measurementFileNames[fileindex]);
                measurementFile = new MeasurementFile(this.measurementsPath, (String)measurementFileNames[fileindex]);
                if (measurementFile.length == 0L) continue;
                if (this.SN == null) {
                    this.SN = measurementFile.sensorSN;
                    this.scrub = measurementFile.Scrub;
                    this.angle = measurementFile.Angle;
                }
                if (!this.SN.contentEquals(measurementFile.sensorSN)) {
                    System.out.println("Incorrect sensor: " + this.SN);
                    continue;
                }
                if (this.battery == null) {
                    this.battery = new TimeSeries((Comparable)((Object)"Battery"));
                    this.temperature = new TimeSeries((Comparable)((Object)"Temperature"));
                    this.Wipes = new TimeSeries((Comparable)((Object)"Wipes Completed"));
                    this.WipeTime = new TimeSeries((Comparable)((Object)"Wipe Time"));
                    this.AverageCurrent = new TimeSeries((Comparable)((Object)"Average Current"));
                    this.FinalCurrent = new TimeSeries((Comparable)((Object)"Final Current"));
                    this.RSource = new TimeSeries((Comparable)((Object)"Source Resistance"));
                    this.Energy = new TimeSeries((Comparable)((Object)"Wipe Energy"));
                    if (measurementFile.Type == 0) {
                        this.CalWipeTime = new TimeSeries((Comparable)((Object)"Cal Wipe Time"));
                        this.StartCurrent = new TimeSeries((Comparable)((Object)"Start Current"));
                        this.PeakCurrent = new TimeSeries((Comparable)((Object)"Peak Current"));
                    } else {
                        this.StartCurrent = new TimeSeries((Comparable)((Object)"Forward Start Current"));
                        this.PeakCurrent = new TimeSeries((Comparable)((Object)"Reverse Start Current"));
                    }
                }
                while (measurementFile.readScan() != -1) {
                    Second mysecond = new Second(new Date(measurementFile.scanTime * 1000L));
                    this.battery.addOrUpdate((RegularTimePeriod)mysecond, measurementFile.Battery);
                    this.temperature.addOrUpdate((RegularTimePeriod)mysecond, measurementFile.T);
                    this.Wipes.addOrUpdate((RegularTimePeriod)mysecond, measurementFile.Wipes);
                    if (measurementFile.Type == 0) {
                        this.CalWipeTime.addOrUpdate((RegularTimePeriod)mysecond, measurementFile.CalWipeTime);
                    }
                    this.WipeTime.addOrUpdate((RegularTimePeriod)mysecond, measurementFile.WipeTime);
                    this.StartCurrent.addOrUpdate((RegularTimePeriod)mysecond, measurementFile.StartCurrent);
                    this.AverageCurrent.addOrUpdate((RegularTimePeriod)mysecond, measurementFile.AverageCurrent);
                    this.PeakCurrent.addOrUpdate((RegularTimePeriod)mysecond, measurementFile.PeakCurrent);
                    this.FinalCurrent.addOrUpdate((RegularTimePeriod)mysecond, measurementFile.FinalCurrent);
                    this.RSource.addOrUpdate((RegularTimePeriod)mysecond, measurementFile.RSource);
                    double totaltime = 0.0;
                    totaltime = measurementFile.OSrevision <= 2.27 ? (measurementFile.WipeTime + 4.0 * measurementFile.CalWipeTime * ((double)this.angle / 240.0)) / 3600.0 : (measurementFile.Type == 0 ? (measurementFile.WipeTime + 4.0 * measurementFile.CalWipeTime * ((double)this.angle / 240.0)) / 3600.0 : measurementFile.WipeTime / 3600.0);
                    this.Energy.addOrUpdate((RegularTimePeriod)mysecond, 5.0 * (measurementFile.AverageCurrent / 1000.0) * totaltime);
                }
                measurementFile.close();
                continue;
            }
            catch (IOException e) {
                throw new IOException("File: " + (String)measurementFileNames[fileindex] + "\n" + e);
            }
            catch (NumberFormatException n) {
                throw new NumberFormatException("File: " + (String)measurementFileNames[fileindex] + "\n" + n);
            }
        }
        this.updateProgress(0);
    }

    private void updateProgress(final int value) {
        Runnable dorun = new Runnable(){

            public void run() {
                Concatenate.this.mpb.setValue(value);
            }
        };
        try {
            SwingUtilities.invokeLater(dorun);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isMeasurementFile(String filename) {
        return filename.charAt(4) == '-' && filename.charAt(7) == '-' && filename.charAt(17) == 'Z' && filename.endsWith(".txt");
    }
}

