/*
 * Decompiled with CFR 0.152.
 */
package Plot;

import com.pme.control.Concatenate;
import java.awt.Color;
import java.awt.Dimension;
import java.io.IOException;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.ui.ApplicationFrame;

public class MiscParam
extends ApplicationFrame {
    private JProgressBar mpb;
    private Concatenate c;

    public MiscParam(JProgressBar mpb, String title, Concatenate c) throws IOException {
        super(title);
        this.mpb = mpb;
        this.c = c;
        this.updateProgress(true);
        ChartPanel chartPanel = (ChartPanel)this.createDemoPanel();
        chartPanel.setPreferredSize(new Dimension(600, 400));
        chartPanel.setDomainZoomable(true);
        chartPanel.setRangeZoomable(true);
        this.setContentPane(chartPanel);
        this.updateProgress(false);
    }

    private JFreeChart createChart() {
        XYLineAndShapeRenderer renderer;
        TimeSeriesCollection dataset1 = new TimeSeriesCollection();
        dataset1.addSeries(this.c.temperature);
        JFreeChart chart = ChartFactory.createTimeSeriesChart("miniWiper Misc Parameters", "Local Time", "Temperature (deg C)", dataset1, true, true, false);
        chart.addSubtitle(new TextTitle(this.c.SN));
        XYPlot plot = (XYPlot)chart.getPlot();
        plot.setOrientation(PlotOrientation.VERTICAL);
        plot.setDomainPannable(true);
        plot.setRangePannable(true);
        plot.getRangeAxis().setFixedDimension(15.0);
        NumberAxis axis2 = new NumberAxis("Battery (Volt)");
        axis2.setAutoRangeIncludesZero(false);
        plot.setRangeAxis(1, axis2);
        plot.setRangeAxisLocation(1, AxisLocation.BOTTOM_OR_LEFT);
        TimeSeriesCollection dataset2 = new TimeSeriesCollection();
        dataset2.addSeries(this.c.battery);
        plot.setDataset(1, dataset2);
        plot.mapDatasetToRangeAxis(1, 1);
        XYLineAndShapeRenderer renderer2 = new XYLineAndShapeRenderer();
        plot.setRenderer(1, renderer2);
        NumberAxis axis3 = new NumberAxis("Wipes Completed ()");
        plot.setRangeAxis(2, axis3);
        TimeSeriesCollection dataset3 = new TimeSeriesCollection();
        dataset3.addSeries(this.c.Wipes);
        plot.setDataset(2, dataset3);
        plot.mapDatasetToRangeAxis(2, 2);
        XYLineAndShapeRenderer renderer3 = new XYLineAndShapeRenderer();
        plot.setRenderer(2, renderer3);
        NumberAxis axis4 = new NumberAxis("Resistance (Ohm)");
        plot.setRangeAxis(3, axis4);
        TimeSeriesCollection dataset4 = new TimeSeriesCollection();
        dataset4.addSeries(this.c.RSource);
        plot.setDataset(3, dataset4);
        plot.mapDatasetToRangeAxis(3, 3);
        XYLineAndShapeRenderer renderer4 = new XYLineAndShapeRenderer();
        plot.setRenderer(3, renderer4);
        ChartUtilities.applyCurrentTheme(chart);
        XYItemRenderer renderer1 = plot.getRenderer();
        renderer1.setSeriesPaint(0, Color.black);
        if (renderer1 instanceof XYLineAndShapeRenderer) {
            renderer = (XYLineAndShapeRenderer)renderer1;
            renderer.setBaseShapesVisible(true);
        }
        renderer2.setSeriesPaint(0, Color.red);
        axis2.setLabelPaint(Color.red);
        axis2.setTickLabelPaint(Color.red);
        renderer3.setSeriesPaint(0, Color.blue);
        axis3.setLabelPaint(Color.blue);
        axis3.setTickLabelPaint(Color.blue);
        if (renderer3 instanceof XYLineAndShapeRenderer) {
            renderer = renderer3;
            renderer.setBaseShapesVisible(true);
        }
        renderer4.setSeriesPaint(0, Color.green);
        axis4.setLabelPaint(Color.green);
        axis4.setTickLabelPaint(Color.green);
        if (renderer4 instanceof XYLineAndShapeRenderer) {
            renderer = renderer4;
            renderer.setBaseShapesVisible(true);
        }
        return chart;
    }

    public JPanel createDemoPanel() {
        JFreeChart chart = this.createChart();
        ChartPanel panel = new ChartPanel(chart);
        panel.setMouseWheelEnabled(true);
        return panel;
    }

    private void updateProgress(final boolean value) {
        Runnable dorun = new Runnable(){

            public void run() {
                MiscParam.this.mpb.setIndeterminate(value);
            }
        };
        try {
            SwingUtilities.invokeLater(dorun);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

