/*
 * Decompiled with CFR 0.152.
 */
package Plot;

import com.pme.control.Concatenate;
import java.awt.Color;
import java.awt.Dimension;
import java.io.IOException;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.ui.ApplicationFrame;

public class EnergyConsumption
extends ApplicationFrame {
    private JProgressBar mpb;
    private Concatenate c;

    public EnergyConsumption(JProgressBar mpb, String title, Concatenate c) throws IOException {
        super(title);
        this.mpb = mpb;
        this.c = c;
        this.updateProgress(true);
        ChartPanel chartPanel = (ChartPanel)this.createDemoPanel();
        chartPanel.setPreferredSize(new Dimension(600, 400));
        chartPanel.setDomainZoomable(true);
        chartPanel.setRangeZoomable(true);
        this.setContentPane(chartPanel);
        this.updateProgress(false);
    }

    private JFreeChart createChart() {
        TimeSeriesCollection dataset1 = new TimeSeriesCollection();
        dataset1.addSeries(this.c.Energy);
        JFreeChart chart = ChartFactory.createTimeSeriesChart("miniWiper Energy Consumption", "Local Time", "Energy per Wipe (Watt-hour)", dataset1, true, true, false);
        chart.addSubtitle(new TextTitle(this.c.SN));
        XYPlot plot = (XYPlot)chart.getPlot();
        plot.setOrientation(PlotOrientation.VERTICAL);
        plot.setDomainPannable(true);
        plot.setRangePannable(true);
        ChartUtilities.applyCurrentTheme(chart);
        XYItemRenderer renderer1 = plot.getRenderer();
        renderer1.setSeriesPaint(0, Color.black);
        if (renderer1 instanceof XYLineAndShapeRenderer) {
            XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)renderer1;
            renderer.setBaseShapesVisible(true);
        }
        return chart;
    }

    public JPanel createDemoPanel() {
        JFreeChart chart = this.createChart();
        ChartPanel panel = new ChartPanel(chart);
        panel.setMouseWheelEnabled(true);
        return panel;
    }

    private void updateProgress(final boolean value) {
        Runnable dorun = new Runnable(){

            public void run() {
                EnergyConsumption.this.mpb.setIndeterminate(value);
            }
        };
        try {
            SwingUtilities.invokeLater(dorun);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

