/*
 * Decompiled with CFR 0.152.
 */
package Time;

import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class ConvertTime {
    ParsePosition pos = new ParsePosition(0);
    Calendar cal = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
    DateFormat df;
    Date dte;

    public ConvertTime() {
        this.df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.US);
        this.df.setCalendar(this.cal);
    }

    public ConvertTime(String format) {
        this.df = new SimpleDateFormat(format, Locale.US);
        this.df.setCalendar(this.cal);
    }

    public long timeFromDate(String datestring) {
        this.pos.setIndex(0);
        this.dte = this.df.parse(datestring, this.pos);
        return this.dte.getTime() / 1000L;
    }

    public String dateFromTimeUTC(long timesecond) {
        this.cal.setTimeInMillis(timesecond * 1000L);
        String timestring = "" + this.cal.get(1) + "-" + (this.cal.get(2) + 1) + "-" + this.cal.get(5) + " " + this.cal.get(11) + ":" + this.cal.get(12) + ":" + this.cal.get(13);
        return timestring;
    }

    public String dateFromTimeLocal(long timesecond) {
        this.cal.setTimeInMillis(timesecond * 1000L);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        formatter.setTimeZone(TimeZone.getDefault());
        return formatter.format(this.cal.getTime());
    }

    public String dayFromTimeLocal(long timesecond) {
        this.cal.setTimeInMillis(timesecond * 1000L);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        formatter.setTimeZone(TimeZone.getDefault());
        return formatter.format(this.cal.getTime());
    }
}

