/*
 * Decompiled with CFR 0.152.
 */
package Device;

import Hid.HidInterface;
import java.io.IOException;

public class Mission {
    public static final String Rev = "1.02";
    private final HidInterface intf;
    private double OSRev = 0.0;
    public int mode;
    public int scrubs;
    public int angle;
    public int warmup;
    public int wipeCount;
    public int fullWipe;
    public int threshold;
    public int wipeType;
    public static final int CALMODE = 0;
    public static final int NORMALMODE = 1;
    public static final int FASTMODE = 2;
    public static final int SLOWMODE = 3;
    public static final int WIPEMINIDOT = 0;
    public static final int WIPEC7 = 1;

    public Mission(HidInterface intf, String OSRev) throws IOException {
        this.intf = intf;
        this.OSRev = Double.parseDouble(OSRev.trim());
    }

    public void getAll() throws IOException {
        this.mode = this.getMode();
        this.scrubs = this.getScrubs();
        this.angle = this.getAngle();
        this.warmup = this.getWarmUp();
        this.wipeCount = this.getWipeCount();
        this.fullWipe = this.getFullWipe();
        this.threshold = this.getThreshold();
        this.wipeType = this.OSRev < 2.27 ? 0 : this.getWipeType();
    }

    public int getAngle() throws IOException {
        return Integer.parseInt(this.intf.transact("ANGLE?"));
    }

    public int getMode() throws IOException {
        return Integer.parseInt(this.intf.transact("MODE?"));
    }

    public int getScrubs() throws IOException {
        return Integer.parseInt(this.intf.transact("SCRUBS?"));
    }

    public int getThreshold() throws IOException {
        return Integer.parseInt(this.intf.transact("THRESHOLD?"));
    }

    public int getWipeType() throws IOException {
        return Integer.parseInt(this.intf.transact("WIPETYPE?"));
    }

    public int getFullWipe() throws IOException {
        return Integer.parseInt(this.intf.transact("FULLWIPE?"));
    }

    public int getWarmUp() throws IOException {
        return Integer.parseInt(this.intf.transact("WARMUP?"));
    }

    public int getWipeCount() throws IOException {
        return Integer.parseInt(this.intf.transact("WIPECOUNT?"));
    }

    public void measureBegin() throws IOException {
        this.intf.transact("MBEGIN");
    }

    public void measureEnd() throws IOException {
        this.intf.transact("MEND");
    }

    public String measure() throws IOException {
        return this.intf.transact("MEASURE");
    }

    public void setAngle(int angle) throws IOException {
        this.intf.transact("ANGLE " + angle);
    }

    public void setMode(int mode) throws IOException {
        this.intf.transact("MODE " + mode);
    }

    public void setScrubs(int scrubs) throws IOException {
        this.intf.transact("SCRUBS " + scrubs);
    }

    public void setThreshold(int threshold) throws IOException {
        this.intf.transact("THRESHOLD " + threshold);
    }

    public void setWipeType(int wipetype) throws IOException {
        this.intf.transact("WIPETYPE " + wipetype);
    }

    public void setFullWipe(int timeout) throws IOException {
        this.intf.transact("FULLWIPE " + timeout);
    }

    public void setWipeCount(int count) throws IOException {
        this.intf.transact("WIPECOUNT " + count);
    }

    public void startMotor() throws IOException {
        this.intf.transact("STRTMTR");
    }

    public void stopMotor() throws IOException {
        this.intf.transact("STOPMTR");
    }

    public void testWipe() throws IOException {
        this.intf.transact("TESTWIPE");
    }
}

