/*
 * Decompiled with CFR 0.152.
 */
package Control;

import Control.Main;
import Device.Logger;
import Device.Mission;
import Hid.HidInterface;
import Time.ConvertTime;
import Time.SntpClient;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.List;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;

public class MainJFrame
extends JFrame {
    private HidInterface hidinterface = null;
    private Mission mission = null;
    private Logger logger = null;
    private SwingWorker<Boolean, Long> timeworker;
    int adjustment;
    int timeError;
    private JButton ConnectButton;
    private JLabel jBUBatLabel;
    private JLabel jBUBatUnit;
    private JLabel jBUBatValue;
    private JLabel jBVLabel;
    private JLabel jBVUnit;
    private JLabel jBVValue;
    private JLabel jClockAdjLabel;
    private JLabel jClockAdjUnit;
    private JLabel jClockAdjValue;
    private JPanel jControlLoggerPanel;
    private JLabel jDateLabel;
    private JLabel jDateUnit;
    private JLabel jDateValue;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JLabel jSNLabel;
    private JLabel jSNValue;
    private JLabel jSampleIntervalLabel;
    private JLabel jSampleIntervalSetIcon;
    private JLabel jSampleIntervalUnit;
    private JLabel jSampleIntervalValue;
    private JTextField jSetSampleIntervalTextBox;
    private JLabel jSetSampleIntervalUnit;
    private JLabel jSoftRevLabel;
    private JLabel jSoftRevValue;
    private JButton jTestWiperButton;
    private JLabel jTimeErrorLabel;
    private JLabel jTimeErrorUnit;
    private JLabel jTimeErrorValue;
    private JLabel jTimeSetIcon;
    private JLabel jTimeSetLabel;
    private JLabel jWipeLabel;
    private JLabel jWipeValue;
    private JButton setWipeIntervalButton;

    public MainJFrame() throws Exception {
        this.initComponents();
        this.getContentPane().setBackground(Color.white);
        this.setTitle("miniWiperControl Rev " + Main.Revision);
        this.jDateUnit.setText("(" + TimeZone.getDefault().getDisplayName() + ")");
        this.jSNLabel.setEnabled(false);
        this.jSNValue.setEnabled(false);
        this.jSoftRevLabel.setEnabled(false);
        this.jSoftRevValue.setEnabled(false);
        this.jDateLabel.setEnabled(false);
        this.jDateValue.setEnabled(false);
        this.jDateUnit.setEnabled(false);
        this.jSampleIntervalLabel.setEnabled(false);
        this.jSampleIntervalValue.setEnabled(false);
        this.jSampleIntervalUnit.setEnabled(false);
        this.jWipeLabel.setEnabled(false);
        this.jWipeValue.setEnabled(false);
        this.jBVLabel.setEnabled(false);
        this.jBVValue.setEnabled(false);
        this.jBVUnit.setEnabled(false);
        this.jBUBatLabel.setEnabled(false);
        this.jBUBatValue.setEnabled(false);
        this.jBUBatUnit.setEnabled(false);
        this.jTimeErrorLabel.setEnabled(false);
        this.jTimeErrorValue.setEnabled(false);
        this.jTimeErrorUnit.setEnabled(false);
        this.jClockAdjLabel.setEnabled(false);
        this.jClockAdjValue.setEnabled(false);
        this.jClockAdjUnit.setEnabled(false);
        this.jTimeSetLabel.setVisible(false);
        this.jTimeSetIcon.setVisible(false);
        this.jSampleIntervalSetIcon.setVisible(false);
        this.jSetSampleIntervalTextBox.setEnabled(false);
        this.jSetSampleIntervalUnit.setEnabled(false);
        this.setWipeIntervalButton.setEnabled(false);
        this.jTestWiperButton.setEnabled(false);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jControlLoggerPanel = new JPanel();
        this.setWipeIntervalButton = new JButton();
        this.jSetSampleIntervalTextBox = new JTextField();
        this.jSetSampleIntervalUnit = new JLabel();
        this.jSampleIntervalSetIcon = new JLabel();
        this.jTestWiperButton = new JButton();
        this.jPanel1 = new JPanel();
        this.ConnectButton = new JButton();
        this.jTimeSetIcon = new JLabel();
        this.jTimeSetLabel = new JLabel();
        this.jSNLabel = new JLabel();
        this.jSNValue = new JLabel();
        this.jSoftRevLabel = new JLabel();
        this.jSoftRevValue = new JLabel();
        this.jDateLabel = new JLabel();
        this.jDateValue = new JLabel();
        this.jSampleIntervalLabel = new JLabel();
        this.jBVLabel = new JLabel();
        this.jBUBatLabel = new JLabel();
        this.jTimeErrorLabel = new JLabel();
        this.jClockAdjLabel = new JLabel();
        this.jSampleIntervalValue = new JLabel();
        this.jBVValue = new JLabel();
        this.jBUBatValue = new JLabel();
        this.jTimeErrorValue = new JLabel();
        this.jClockAdjValue = new JLabel();
        this.jSampleIntervalUnit = new JLabel();
        this.jBVUnit = new JLabel();
        this.jBUBatUnit = new JLabel();
        this.jTimeErrorUnit = new JLabel();
        this.jClockAdjUnit = new JLabel();
        this.jDateUnit = new JLabel();
        this.jWipeLabel = new JLabel();
        this.jWipeValue = new JLabel();
        this.setDefaultCloseOperation(3);
        this.setResizable(false);
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/Resources/PME logo.jpg")));
        this.jLabel1.setToolTipText("Reliable instruments for an unreliable world");
        this.jControlLoggerPanel.setBackground(new Color(255, 255, 255));
        this.jControlLoggerPanel.setBorder(BorderFactory.createTitledBorder("Control Logger"));
        this.setWipeIntervalButton.setText("Set Wipe  Interval");
        this.setWipeIntervalButton.setToolTipText("Set wiper sample interval");
        this.setWipeIntervalButton.setEnabled(false);
        this.setWipeIntervalButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainJFrame.this.setWipeIntervalButtonActionPerformed(evt);
            }
        });
        this.jSetSampleIntervalTextBox.setText("(pending)");
        this.jSetSampleIntervalTextBox.setToolTipText("Enter time between wipes.");
        this.jSetSampleIntervalTextBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainJFrame.this.setWipeIntervalButtonActionPerformed(evt);
            }
        });
        this.jSetSampleIntervalUnit.setText("(minute)");
        this.jSampleIntervalSetIcon.setIcon(new ImageIcon(this.getClass().getResource("/Resources/tic.jpg")));
        this.jTestWiperButton.setText("Test Wiper");
        this.jTestWiperButton.setToolTipText("Operate wiper for 1 wipe");
        this.jTestWiperButton.setEnabled(false);
        this.jTestWiperButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainJFrame.this.jTestWiperButtonActionPerformed(evt);
            }
        });
        GroupLayout jControlLoggerPanelLayout = new GroupLayout(this.jControlLoggerPanel);
        this.jControlLoggerPanel.setLayout(jControlLoggerPanelLayout);
        jControlLoggerPanelLayout.setHorizontalGroup(jControlLoggerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jControlLoggerPanelLayout.createSequentialGroup().addComponent(this.jSampleIntervalSetIcon).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jControlLoggerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jTestWiperButton, -1, -1, Short.MAX_VALUE).addComponent(this.setWipeIntervalButton, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jSetSampleIntervalTextBox, -2, 86, -2).addGap(18, 18, 18).addComponent(this.jSetSampleIntervalUnit)));
        jControlLoggerPanelLayout.setVerticalGroup(jControlLoggerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jControlLoggerPanelLayout.createSequentialGroup().addGroup(jControlLoggerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSampleIntervalSetIcon, GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.TRAILING, jControlLoggerPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.setWipeIntervalButton).addComponent(this.jSetSampleIntervalTextBox, -2, -1, -2).addComponent(this.jSetSampleIntervalUnit))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTestWiperButton).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Logger Status"));
        this.ConnectButton.setText("Connect");
        this.ConnectButton.setToolTipText("Connect to wiper via USB");
        this.ConnectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainJFrame.this.ConnectButtonActionPerformed(evt);
            }
        });
        this.jTimeSetIcon.setIcon(new ImageIcon(this.getClass().getResource("/Resources/tic.jpg")));
        this.jTimeSetLabel.setText("Time Set");
        this.jSNLabel.setText("Logger Serial Number:");
        this.jSNLabel.setToolTipText("Serial number of connected wiper");
        this.jSNValue.setText("(pending)");
        this.jSNValue.setToolTipText("Serial number of wiper");
        this.jSoftRevLabel.setText("Software Revision:");
        this.jSoftRevLabel.setToolTipText("Revision level of wiper internal software");
        this.jSoftRevValue.setText("(pending)");
        this.jSoftRevValue.setToolTipText("Revision of wiper internal software");
        this.jDateLabel.setText("Current Wiper Time:");
        this.jDateLabel.setToolTipText("Present wiper date and time");
        this.jDateValue.setText("(pending)");
        this.jDateValue.setToolTipText("Wiper time (UTC) expressed in host computer time zone");
        this.jSampleIntervalLabel.setText("Wipe Interval:");
        this.jSampleIntervalLabel.setToolTipText("Time between wipes");
        this.jBVLabel.setText("Battery Voltage:");
        this.jBVLabel.setToolTipText("Voltage of wiper battery");
        this.jBUBatLabel.setText("Backup Battery Voltage:");
        this.jTimeErrorLabel.setText("Time Error at Connect:");
        this.jTimeErrorLabel.setToolTipText("Difference of wiper time from  true time at time of connection");
        this.jClockAdjLabel.setText("Clock Speed Adjusted:");
        this.jClockAdjLabel.setToolTipText("Adjustment made to wiper clock speed");
        this.jSampleIntervalValue.setText("(pending)");
        this.jSampleIntervalValue.setToolTipText("Time between wipes");
        this.jBVValue.setText("(pending)");
        this.jBVValue.setToolTipText("Voltage of main wiper battery");
        this.jBUBatValue.setText("(pending)");
        this.jBUBatValue.setToolTipText("Voltage of clock backup battery");
        this.jTimeErrorValue.setText("(pending)");
        this.jTimeErrorValue.setToolTipText("Wiper time - true time determined from internet");
        this.jClockAdjValue.setText("(pending)");
        this.jClockAdjValue.setToolTipText("Fast or slow adjustment to logger clock");
        this.jSampleIntervalUnit.setText("(minute)");
        this.jBVUnit.setText("(Volt)");
        this.jBUBatUnit.setText("(Volt)");
        this.jTimeErrorUnit.setText("(second)");
        this.jClockAdjUnit.setText("(ppm)");
        this.jDateUnit.setText("(UTC)");
        this.jWipeLabel.setText("Wipes:");
        this.jWipeLabel.setToolTipText("# Wipes since battery change");
        this.jWipeValue.setText("(pending)");
        this.jWipeValue.setToolTipText("# Wipes since battery change");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jDateLabel, -1, 130, Short.MAX_VALUE).addComponent(this.jSampleIntervalLabel, -1, -1, Short.MAX_VALUE)).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jTimeErrorLabel, -1, 130, Short.MAX_VALUE).addComponent(this.jClockAdjLabel, -1, -1, Short.MAX_VALUE)).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jBVLabel, -1, -1, Short.MAX_VALUE).addComponent(this.jBUBatLabel, -1, 130, Short.MAX_VALUE)).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jSNLabel, -1, 130, Short.MAX_VALUE).addComponent(this.jSoftRevLabel, -1, -1, Short.MAX_VALUE)).addComponent(this.jWipeLabel)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSNValue, -1, -1, Short.MAX_VALUE).addComponent(this.jSoftRevValue, -1, 128, Short.MAX_VALUE).addComponent(this.jDateValue, -2, 127, -2).addComponent(this.jSampleIntervalValue, -1, -1, Short.MAX_VALUE).addComponent(this.jWipeValue, -1, -1, Short.MAX_VALUE).addComponent(this.jBVValue, -1, -1, Short.MAX_VALUE).addComponent(this.jBUBatValue, -1, -1, Short.MAX_VALUE).addComponent(this.jTimeErrorValue, -1, 128, Short.MAX_VALUE).addComponent(this.jClockAdjValue, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSampleIntervalUnit, GroupLayout.Alignment.TRAILING).addComponent(this.jTimeErrorUnit, GroupLayout.Alignment.TRAILING).addComponent(this.jClockAdjUnit, GroupLayout.Alignment.TRAILING).addComponent(this.jBVUnit, GroupLayout.Alignment.TRAILING).addComponent(this.jBUBatUnit, GroupLayout.Alignment.TRAILING)).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap(363, Short.MAX_VALUE).addComponent(this.jTimeSetIcon).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTimeSetLabel).addGap(10, 10, 10)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.ConnectButton)).addGroup(jPanel1Layout.createSequentialGroup().addGap(293, 293, 293).addComponent(this.jDateUnit))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(15, 15, 15).addComponent(this.ConnectButton)).addComponent(this.jTimeSetLabel).addComponent(this.jTimeSetIcon)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSNLabel).addComponent(this.jSNValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSoftRevLabel).addComponent(this.jSoftRevValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jDateLabel).addComponent(this.jDateValue).addComponent(this.jDateUnit, -2, 14, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSampleIntervalLabel).addComponent(this.jSampleIntervalValue)).addComponent(this.jSampleIntervalUnit)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jWipeLabel).addComponent(this.jWipeValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jBVLabel).addComponent(this.jBVValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jBUBatLabel).addComponent(this.jBUBatValue))).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jBVUnit).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jBUBatUnit))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTimeErrorValue, -2, 14, -2).addComponent(this.jTimeErrorLabel)).addComponent(this.jTimeErrorUnit)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jClockAdjUnit).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jClockAdjLabel).addComponent(this.jClockAdjValue))).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel1).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jControlLoggerPanel, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jControlLoggerPanel, -2, -1, -2).addContainerGap(23, Short.MAX_VALUE)));
        this.pack();
    }

    private void ConnectButtonActionPerformed(ActionEvent evt) {
        try {
            this.hidinterface = new HidInterface();
            this.hidinterface.connect();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Problem connecting to wiper\nIs wiper connected to USB?\nIs wiper LED constantly on?\n" + e);
            return;
        }
        this.ConnectButton.setEnabled(false);
        this.ConnectButton.setText("Reading...");
        SwingWorker<Boolean, Void> systemworker = new SwingWorker<Boolean, Void>(){

            @Override
            protected Boolean doInBackground() {
                try {
                    MainJFrame.this.logger = new Logger(MainJFrame.this.hidinterface);
                    MainJFrame.this.logger.getAll();
                    MainJFrame.this.mission = new Mission(MainJFrame.this.hidinterface, ((MainJFrame)MainJFrame.this).logger.softwareRevision);
                    MainJFrame.this.mission.getAll();
                    if (((MainJFrame)MainJFrame.this).mission.mode == 0) {
                        ((MainJFrame)MainJFrame.this).mission.mode = 3;
                        MainJFrame.this.mission.setMode(((MainJFrame)MainJFrame.this).mission.mode);
                        ((MainJFrame)MainJFrame.this).logger.wipeInterval = 21600;
                        MainJFrame.this.logger.setWipeInterval(((MainJFrame)MainJFrame.this).logger.wipeInterval);
                    }
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(MainJFrame.this, "Problem reading wiper\nIs wiper connected to USB?\nIs wiper LED constantly on?\n" + e);
                    System.exit(-1);
                }
                return true;
            }

            @Override
            protected void done() {
                MainJFrame.this.jSNValue.setText(((MainJFrame)MainJFrame.this).logger.SN);
                MainJFrame.this.jSoftRevValue.setText(((MainJFrame)MainJFrame.this).logger.softwareRevision);
                MainJFrame.this.jWipeValue.setText(String.format("%1$-6d", ((MainJFrame)MainJFrame.this).mission.wipeCount));
                MainJFrame.this.jBVValue.setText(String.format("%1$4.2f", ((MainJFrame)MainJFrame.this).logger.MainBatteryVoltage));
                MainJFrame.this.jBUBatValue.setText(String.format("%1$4.2f", ((MainJFrame)MainJFrame.this).logger.BackupBatteryVoltage));
                try {
                    MainJFrame.this.jDateValue.setText(new ConvertTime().dateFromTimeLocal(MainJFrame.this.logger.getTime()));
                    long UTCtime = SntpClient.getUTCTime();
                    int timeerror = (int)(MainJFrame.this.logger.getTime() - UTCtime);
                    MainJFrame.this.jTimeErrorValue.setText(Integer.toString(timeerror));
                    MainJFrame.this.jTimeErrorUnit.setText("(second)");
                    try {
                        double prevadj = ((MainJFrame)MainJFrame.this).logger.clockFreqAdjustment;
                        Double adjustmentrequired = MainJFrame.this.logger.adjustClockCalibration(timeerror);
                        MainJFrame.this.jClockAdjValue.setText(String.format("%1$3.0f", adjustmentrequired) + " (previous " + String.format("%1$3.0f", prevadj) + ")");
                        MainJFrame.this.jClockAdjUnit.setText("(ppm)");
                        MainJFrame.this.logger.setTime(UTCtime + 1L);
                        MainJFrame.this.jTimeSetLabel.setVisible(true);
                        MainJFrame.this.jTimeSetIcon.setVisible(true);
                    }
                    catch (IOException e) {
                        MainJFrame.this.jClockAdjValue.setText(e.getMessage());
                        MainJFrame.this.jClockAdjUnit.setText("");
                    }
                    MainJFrame.this.jTimeErrorLabel.setEnabled(true);
                    MainJFrame.this.jTimeErrorValue.setEnabled(true);
                    MainJFrame.this.jTimeErrorUnit.setEnabled(true);
                    MainJFrame.this.jClockAdjLabel.setEnabled(true);
                    MainJFrame.this.jClockAdjValue.setEnabled(true);
                    MainJFrame.this.jClockAdjUnit.setEnabled(true);
                }
                catch (IOException eio) {
                    MainJFrame.this.jTimeErrorValue.setText("No Internet Connection");
                    MainJFrame.this.jTimeErrorUnit.setVisible(false);
                    MainJFrame.this.jClockAdjValue.setText("No Internet Connection");
                    MainJFrame.this.jClockAdjUnit.setVisible(false);
                    MainJFrame.this.jTimeErrorLabel.setEnabled(false);
                    MainJFrame.this.jTimeErrorValue.setEnabled(false);
                    MainJFrame.this.jTimeErrorUnit.setEnabled(false);
                    MainJFrame.this.jClockAdjLabel.setEnabled(false);
                    MainJFrame.this.jClockAdjValue.setEnabled(false);
                    MainJFrame.this.jClockAdjUnit.setEnabled(false);
                }
                MainJFrame.this.jSNLabel.setEnabled(true);
                MainJFrame.this.jSNValue.setEnabled(true);
                MainJFrame.this.jSoftRevLabel.setEnabled(true);
                MainJFrame.this.jSoftRevValue.setEnabled(true);
                MainJFrame.this.jDateLabel.setEnabled(true);
                MainJFrame.this.jDateValue.setEnabled(true);
                MainJFrame.this.jDateUnit.setEnabled(true);
                MainJFrame.this.jSampleIntervalLabel.setEnabled(true);
                MainJFrame.this.jSampleIntervalValue.setEnabled(true);
                MainJFrame.this.jSampleIntervalUnit.setEnabled(true);
                MainJFrame.this.jWipeLabel.setEnabled(true);
                MainJFrame.this.jWipeValue.setEnabled(true);
                MainJFrame.this.jBVLabel.setEnabled(true);
                MainJFrame.this.jBVValue.setEnabled(true);
                MainJFrame.this.jBVUnit.setEnabled(true);
                MainJFrame.this.jBUBatLabel.setEnabled(true);
                MainJFrame.this.jBUBatValue.setEnabled(true);
                MainJFrame.this.jBUBatUnit.setEnabled(true);
                switch (((MainJFrame)MainJFrame.this).mission.mode) {
                    case 0: {
                        MainJFrame.this.jSetSampleIntervalUnit.setText("(calibration)");
                        MainJFrame.this.jSetSampleIntervalTextBox.setText("CAL");
                        MainJFrame.this.jSampleIntervalValue.setText("CAL");
                        MainJFrame.this.jSetSampleIntervalUnit.setVisible(false);
                        MainJFrame.this.jSampleIntervalUnit.setVisible(false);
                        MainJFrame.this.jSetSampleIntervalTextBox.setEnabled(false);
                        MainJFrame.this.setWipeIntervalButton.setEnabled(false);
                        break;
                    }
                    case 2: {
                        MainJFrame.this.jSetSampleIntervalUnit.setText("(second)");
                        MainJFrame.this.jSetSampleIntervalUnit.setEnabled(true);
                        MainJFrame.this.jSampleIntervalUnit.setText("(second)");
                        MainJFrame.this.setWipeIntervalButton.setEnabled(true);
                        MainJFrame.this.jSetSampleIntervalTextBox.setText(Integer.toString(((MainJFrame)MainJFrame.this).logger.wipeInterval));
                        MainJFrame.this.jSampleIntervalValue.setText(Integer.toString(((MainJFrame)MainJFrame.this).logger.wipeInterval));
                        MainJFrame.this.jSetSampleIntervalTextBox.setEnabled(true);
                        MainJFrame.this.setWipeIntervalButton.setEnabled(true);
                        break;
                    }
                    case 1: {
                        MainJFrame.this.jSetSampleIntervalUnit.setText("(minute)");
                        MainJFrame.this.jSetSampleIntervalUnit.setEnabled(true);
                        MainJFrame.this.jSampleIntervalUnit.setText("(minute)");
                        MainJFrame.this.jSetSampleIntervalTextBox.setText(Integer.toString(((MainJFrame)MainJFrame.this).logger.wipeInterval / 60));
                        MainJFrame.this.jSampleIntervalValue.setText(Integer.toString(((MainJFrame)MainJFrame.this).logger.wipeInterval / 60));
                        MainJFrame.this.setWipeIntervalButton.setEnabled(true);
                        MainJFrame.this.jSetSampleIntervalTextBox.setEnabled(true);
                        MainJFrame.this.setWipeIntervalButton.setEnabled(true);
                        break;
                    }
                    case 3: {
                        MainJFrame.this.jSetSampleIntervalUnit.setText("(hour)");
                        MainJFrame.this.jSetSampleIntervalUnit.setEnabled(true);
                        MainJFrame.this.jSampleIntervalUnit.setText("(hour)");
                        MainJFrame.this.jSetSampleIntervalTextBox.setText(Integer.toString(((MainJFrame)MainJFrame.this).logger.wipeInterval / 3600));
                        MainJFrame.this.jSampleIntervalValue.setText(Integer.toString(((MainJFrame)MainJFrame.this).logger.wipeInterval / 3600));
                        MainJFrame.this.setWipeIntervalButton.setEnabled(true);
                        MainJFrame.this.jSetSampleIntervalTextBox.setEnabled(true);
                        MainJFrame.this.setWipeIntervalButton.setEnabled(true);
                    }
                }
                MainJFrame.this.jTestWiperButton.setEnabled(true);
                MainJFrame.this.ConnectButton.setBackground(Color.green);
                MainJFrame.this.ConnectButton.setText("Connected!");
                MainJFrame.this.createTimeWorker();
                MainJFrame.this.timeworker.execute();
            }
        };
        systemworker.execute();
    }

    private void setWipeIntervalButtonActionPerformed(ActionEvent evt) {
        try {
            int sampleInterval = Integer.parseInt(this.jSetSampleIntervalTextBox.getText());
            switch (this.mission.mode) {
                case 3: {
                    if (sampleInterval <= 24 && sampleInterval >= 1) {
                        this.logger.setWipeInterval(sampleInterval * 3600);
                        this.setWipeIntervalButton.setText("Interval now " + sampleInterval + " hours)");
                        break;
                    }
                    throw new NumberFormatException("Entry out of range!");
                }
                case 1: {
                    if (sampleInterval <= 60 && sampleInterval >= 1) {
                        this.logger.setWipeInterval(sampleInterval * 60);
                        this.setWipeIntervalButton.setText("Interval now " + sampleInterval + " minutes");
                        break;
                    }
                    throw new NumberFormatException("Entry out of range!");
                }
                case 2: {
                    if (sampleInterval <= 3600 && sampleInterval >= this.mission.warmup + 5) {
                        this.logger.setWipeInterval(sampleInterval);
                        this.setWipeIntervalButton.setText("Interval now " + sampleInterval + " seconds");
                        break;
                    }
                    throw new NumberFormatException("Entry out of range!");
                }
            }
            this.jSampleIntervalValue.setText(this.jSetSampleIntervalTextBox.getText());
            this.jSampleIntervalSetIcon.setVisible(true);
        }
        catch (NumberFormatException e) {
            switch (this.mission.mode) {
                case 3: {
                    JOptionPane.showMessageDialog(this, "Please enter an interval between 1 and 24 hours.");
                    break;
                }
                case 1: {
                    JOptionPane.showMessageDialog(this, "Please enter an interval between 1 and 60 minutes.");
                    break;
                }
                case 2: {
                    JOptionPane.showMessageDialog(this, "Please enter an interval between " + (this.mission.warmup + 5) + " and 3600 seconds.");
                }
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Problem connecting to wiper\nIs wiper connected to USB?\nIs wiper LED constantly on?\n" + e);
            System.exit(-1);
        }
    }

    private void jTestWiperButtonActionPerformed(ActionEvent evt) {
        this.jTestWiperButton.setEnabled(false);
        try {
            this.mission.testWipe();
            ++this.mission.wipeCount;
            this.jWipeValue.setText(String.format("%1$-6d", this.mission.wipeCount));
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Problem reading wiper\nIs wiper connected to USB?\nIs wiper LED constantly on?\n" + e);
            System.exit(-1);
        }
        this.jTestWiperButton.setEnabled(true);
    }

    private void createTimeWorker() {
        this.timeworker = new SwingWorker<Boolean, Long>(){

            @Override
            protected Boolean doInBackground() {
                while (!this.isCancelled()) {
                    try {
                        Long t = MainJFrame.this.logger.getTime();
                        this.publish(t);
                        Thread.sleep(100L);
                    }
                    catch (IOException e) {
                        JOptionPane.showMessageDialog(MainJFrame.this, "Time Thread problem reading wiper\n" + e);
                        System.exit(-1);
                    }
                    catch (InterruptedException ee) {
                        JOptionPane.showMessageDialog(MainJFrame.this, "Problem with thread sleep" + ee);
                        System.exit(-1);
                    }
                }
                return true;
            }

            @Override
            protected void process(List<Long> chunks) {
                MainJFrame.this.jDateValue.setText(new ConvertTime().dateFromTimeLocal(chunks.get(chunks.size() - 1)));
            }
        };
    }
}

