/*
 * Decompiled with CFR 0.152.
 */
package com.pme.control;

import com.pme.calc.Vector;
import com.pme.io.MeasurementFile;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimeSeries;

public class Concatenate {
    public TimeSeries battery = new TimeSeries((Comparable)((Object)"Battery"));
    public TimeSeries temperature = new TimeSeries((Comparable)((Object)"Temperature"));
    public TimeSeries PAR = new TimeSeries((Comparable)((Object)"PAR"));
    public TimeSeries Tilt = new TimeSeries((Comparable)((Object)"Tilt"));
    public String SN = null;
    private final String measurementsPath;
    private final JProgressBar mpb;

    public Concatenate(JProgressBar mpb, String measurementsPath) {
        this.measurementsPath = measurementsPath;
        this.mpb = mpb;
    }

    public void Concatenate() throws IOException, NumberFormatException {
        int i;
        MeasurementFile measurementFile = null;
        File measurementsFolder = new File(this.measurementsPath);
        String[] measurementFilesAndMaybeOthers = measurementsFolder.list();
        int j = 0;
        for (i = 0; i < measurementFilesAndMaybeOthers.length; ++i) {
            if (!this.isMeasurementFile(measurementFilesAndMaybeOthers[i])) continue;
            ++j;
        }
        if (j == 0) {
            IOException mye = new IOException("No miniDOT .TXT files found");
            throw mye;
        }
        Object[] measurementFileNames = new String[j];
        j = 0;
        for (i = 0; i < measurementFilesAndMaybeOthers.length; ++i) {
            if (!this.isMeasurementFile(measurementFilesAndMaybeOthers[i])) continue;
            measurementFileNames[j] = measurementFilesAndMaybeOthers[i];
            ++j;
        }
        measurementFilesAndMaybeOthers = null;
        Arrays.sort(measurementFileNames);
        for (int fileindex = 0; fileindex < measurementFileNames.length; ++fileindex) {
            try {
                this.updateProgress((int)(100.0 * (double)fileindex / (double)measurementFileNames.length));
                System.out.println("processing file: " + (String)measurementFileNames[fileindex]);
                measurementFile = new MeasurementFile(this.measurementsPath, (String)measurementFileNames[fileindex]);
                if (measurementFile.length == 0L) continue;
                if (this.SN == null) {
                    this.SN = measurementFile.sensorSN;
                }
                if (!this.SN.contentEquals(measurementFile.sensorSN)) {
                    System.out.println("Incorrect sensor: " + this.SN);
                    continue;
                }
                while (measurementFile.readScan() != -1) {
                    Second mysecond = new Second(new Date(measurementFile.scanTime * 1000L));
                    this.battery.addOrUpdate((RegularTimePeriod)mysecond, measurementFile.Battery);
                    this.temperature.addOrUpdate((RegularTimePeriod)mysecond, measurementFile.T);
                    this.PAR.addOrUpdate((RegularTimePeriod)mysecond, measurementFile.PAR);
                    Vector u = new Vector(measurementFile.aX, measurementFile.aY, measurementFile.aZ);
                    double angledeg = u.angleDeg(new Vector(1.0, 0.0, 0.0));
                    this.Tilt.addOrUpdate((RegularTimePeriod)mysecond, angledeg);
                }
                measurementFile.close();
                continue;
            }
            catch (IOException e) {
                throw new IOException("File: " + (String)measurementFileNames[fileindex] + "\n" + e);
            }
            catch (NumberFormatException n) {
                throw new NumberFormatException("File: " + (String)measurementFileNames[fileindex] + "\n" + n);
            }
        }
        this.updateProgress(0);
    }

    private void updateProgress(final int value) {
        Runnable dorun = new Runnable(){

            public void run() {
                Concatenate.this.mpb.setValue(value);
            }
        };
        try {
            SwingUtilities.invokeLater(dorun);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isMeasurementFile(String filename) {
        return filename.charAt(4) == '-' && filename.charAt(7) == '-' && filename.charAt(17) == 'Z' && filename.endsWith(".txt");
    }
}

