/*
 * Decompiled with CFR 0.152.
 */
package Device;

import Hid.HidInterface;
import java.io.IOException;

public class Mission {
    public static final String Rev = "1.00";
    private final HidInterface intf;
    public long timeOfLastCalibration;
    public int mode;
    public double[] PARCoef = new double[3];
    public double[] DepthCoef = new double[4];
    public double[] TCoef = new double[5];
    public static final int CALMODE = 0;
    public static final int NORMALMODE = 1;
    public static final int FASTMODE = 2;
    public static final int SLOWMODE = 3;

    public Mission(HidInterface intf) throws IOException {
        this.intf = intf;
    }

    public void getAll() throws IOException {
        this.timeOfLastCalibration = this.getCalTime();
        this.mode = this.getCalFlag();
        this.PARCoef = this.getCoef("PARCOEF");
        this.DepthCoef = this.getCoef("DEPTHCOEF");
        this.TCoef = this.getCoef("TCOEF");
    }

    public long getCalTime() throws IOException {
        return Integer.parseInt(this.intf.transact("CALTIME?"));
    }

    public int getCalFlag() throws IOException {
        return Integer.parseInt(this.intf.transact("MODE?"));
    }

    private double[] getCoef(String coeftype) throws IOException {
        String ss = this.intf.transact(coeftype + "?");
        String[] ps = ss.split(",");
        double[] c = new double[ps.length];
        for (int i = 0; i < ps.length; ++i) {
            c[i] = Double.parseDouble(ps[i]);
        }
        return c;
    }

    public String measure() throws IOException {
        return this.intf.transact("MEASURE");
    }

    public void setCalTime(long caltime) throws IOException {
        this.intf.transact("CALTIME " + caltime);
    }

    public void setMode(int mode) throws IOException {
        this.intf.transact("MODE " + mode);
    }

    public void setPARCOEF(double[] c) throws IOException {
        this.setCoef("PARCOEF", c);
    }

    public void setDepthCOEF(double[] c) throws IOException {
        this.setCoef("DEPTHCOEF", c);
    }

    public void setTCOEF(double[] c) throws IOException {
        this.setCoef("TCOEF", c);
    }

    private void setCoef(String coeftype, double[] c) throws IOException {
        String s = coeftype + " ";
        for (int i = 0; i < c.length; ++i) {
            s = i < c.length - 1 ? s + String.format("%1$12.8e", c[i]) + ',' : s + String.format("%1$12.8e", c[i]);
        }
        this.intf.transact(s);
    }
}

