/*
 * Decompiled with CFR 0.152.
 */
package com.pme.control;

import com.pme.control.Concatenator;
import com.pme.control.Main;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;

public class MainJFrame
extends JFrame {
    private ButtonGroup buttonGroup1;
    private JFileChooser dataFileChooser;
    private JButton jImportButton;
    private JLabel jImportLabel;
    private JLabel jLabel1;
    private JButton jProcessButton;
    private JProgressBar jProgressBar;

    public MainJFrame() {
        int i;
        this.initComponents();
        this.getContentPane().setBackground(Color.white);
        this.setTitle("miniPAR Concatenate Rev " + Main.Revision);
        String workingFolder = System.getProperty("user.dir");
        System.out.println("Working directory: " + workingFolder);
        File measurementsFolder = new File(workingFolder);
        String[] measurementFilesAndMaybeOthers = measurementsFolder.list();
        for (i = 0; i < measurementFilesAndMaybeOthers.length && !measurementFilesAndMaybeOthers[i].contains("7530-"); ++i) {
        }
        if (i < measurementFilesAndMaybeOthers.length) {
            this.jImportLabel.setText(workingFolder + File.separatorChar + measurementFilesAndMaybeOthers[i]);
            this.jProcessButton.setEnabled(true);
        } else {
            this.jImportLabel.setText("none selected");
            this.jProcessButton.setEnabled(false);
        }
    }

    private void initComponents() {
        this.dataFileChooser = new JFileChooser();
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jImportButton = new JButton();
        this.jProcessButton = new JButton();
        this.jImportLabel = new JLabel();
        this.jProgressBar = new JProgressBar();
        this.setDefaultCloseOperation(3);
        this.setBackground(new Color(255, 255, 255));
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/com/pme/resources/PME logo.jpg")));
        this.jImportButton.setText("Select DATA Folder");
        this.jImportButton.setToolTipText("Select 'Data' folder containing miniDOT Logger files.");
        this.jImportButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainJFrame.this.jImportButtonActionPerformed(evt);
            }
        });
        this.jProcessButton.setText("Concatenate");
        this.jProcessButton.setToolTipText("Read files, create plot, create concatenated file.");
        this.jProcessButton.setEnabled(false);
        this.jProcessButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainJFrame.this.jProcessButtonActionPerformed(evt);
            }
        });
        this.jImportLabel.setText("(none selected)");
        this.jImportLabel.setToolTipText("The location of miniDOT Logger files.");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jImportButton).addComponent(this.jProcessButton)).addGap(7, 7, 7).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jProgressBar, -2, 218, -2).addComponent(this.jImportLabel, GroupLayout.Alignment.TRAILING, -1, 297, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(7, 7, 7).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jImportButton).addComponent(this.jImportLabel, -2, 19, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jProcessButton).addComponent(this.jProgressBar, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jImportButtonActionPerformed(ActionEvent evt) {
        this.dataFileChooser.setFileSelectionMode(1);
        this.dataFileChooser.setDialogTitle("Select miniPAR DATA folder");
        int returnVal = this.dataFileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            File file = this.dataFileChooser.getSelectedFile();
            File d = this.dataFileChooser.getCurrentDirectory();
            this.jImportLabel.setText(d.getPath() + File.separatorChar + file.getName());
            this.jProcessButton.setEnabled(true);
        }
        if (returnVal == 1) {
            this.jImportLabel.setText("(canceled)");
            this.jProcessButton.setEnabled(false);
        }
    }

    private void jProcessButtonActionPerformed(ActionEvent evt) {
        final MainJFrame mjf = this;
        File mc = new File(this.jImportLabel.getText() + File.separatorChar + "CAT.TXT");
        if (mc.exists() && JOptionPane.showConfirmDialog(mjf, "Delete previous concatenated file?") != 0) {
            return;
        }
        this.jProcessButton.setEnabled(false);
        Runnable myRunnable = new Runnable(){

            public void run() {
                Concatenator myc = new Concatenator(MainJFrame.this.jProgressBar, MainJFrame.this.jImportLabel.getText());
                try {
                    myc.Concatenate();
                }
                catch (IOException e) {
                    System.out.println("IOException: " + e);
                    JOptionPane.showMessageDialog(mjf, "IOException: " + e, "miniPAR Concatenate Error", 0);
                    System.exit(0);
                }
                catch (NumberFormatException n) {
                    System.out.println("Number format error " + n);
                    JOptionPane.showMessageDialog(mjf, "Number Format Error: " + n, "miniPAR Concatenate Error", 0);
                    System.exit(0);
                }
                JOptionPane.showMessageDialog(mjf, "miniPAR measurement files concatenated into\n" + MainJFrame.this.jImportLabel.getText() + "\\CAT.txt", "Concatenation Completed", 1);
                Runnable dorun = new Runnable(){

                    public void run() {
                        MainJFrame.this.jProcessButton.setEnabled(true);
                    }
                };
                try {
                    SwingUtilities.invokeLater(dorun);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        Thread thread = new Thread(myRunnable);
        thread.start();
    }
}

