/*
 * Decompiled with CFR 0.152.
 */
package com.pme.calc;

public class ConcO2GG {
    public static double DOConcMg(double T, double P, double S) {
        return ConcO2GG.DOConcUmol(T, P, S) * 31.9988 / 1000.0;
    }

    public static double DOConcUmol(double T, double P, double S) {
        double Ptotal = P / 101325.0;
        double pWSat = ConcO2GG.SaturatedWaterVaporPressure(T, S);
        double pO2measured = ConcO2GG.pO2(Ptotal - pWSat);
        double pO2reference = ConcO2GG.pO2(1.0 - pWSat);
        return ConcO2GG.CoStar(T, S) * pO2measured / pO2reference;
    }

    public static double SaturatedWaterVaporPressure(double T, double S) {
        double TK = T + 273.15;
        return Math.exp(24.4543 - 67.4509 * (100.0 / TK) - 4.8489 * Math.log(TK / 100.0) - 5.44E-4 * S);
    }

    private static double CoStar(double T, double S) {
        double A0 = 2.00907;
        double A1 = 3.22014;
        double A2 = 4.0501;
        double A3 = 4.94457;
        double A4 = -0.256847;
        double A5 = 3.88767;
        double B0 = -0.00624523;
        double B1 = -0.00737614;
        double B2 = -0.010341;
        double B3 = -0.00817083;
        double C0 = -4.88682E-7;
        double Ts = Math.log((298.15 - T) / (273.15 + T));
        double CoStar = Math.exp(A0 + A1 * Ts + A2 * Math.pow(Ts, 2.0) + A3 * Math.pow(Ts, 3.0) + A4 * Math.pow(Ts, 4.0) + A5 * Math.pow(Ts, 5.0) + S * (B0 + B1 * Ts + B2 * Math.pow(Ts, 2.0) + B3 * Math.pow(Ts, 3.0)) + C0 * Math.pow(S, 2.0));
        return CoStar *= 44.6596044945426;
    }

    private static double pO2(double P) {
        return 0.209446 * P;
    }

    public static double SalinityFactor(double T, double S) {
        if (S != 0.0) {
            return ConcO2GG.DOConcMg(T, 101325.0, S) / ConcO2GG.DOConcMg(T, 101325.0, 0.0);
        }
        return 1.0;
    }
}

