/*
 * Decompiled with CFR 0.152.
 */
package com.pme.control;

import com.pme.control.Concatenate;
import java.awt.Color;
import java.awt.Dimension;
import java.io.IOException;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.ui.ApplicationFrame;

public class Plot
extends ApplicationFrame {
    private String sensorSN;
    private JProgressBar mpb;
    private Concatenate c;

    public Plot(JProgressBar mpb, String title, Concatenate c) throws IOException {
        super(title);
        this.mpb = mpb;
        this.c = c;
        this.updateProgress(true);
        ChartPanel chartPanel = (ChartPanel)this.createDemoPanel();
        chartPanel.setPreferredSize(new Dimension(600, 400));
        chartPanel.setDomainZoomable(true);
        chartPanel.setRangeZoomable(true);
        this.setContentPane(chartPanel);
        this.updateProgress(false);
    }

    private JFreeChart createChart() {
        TimeSeriesCollection dataset1 = new TimeSeriesCollection();
        dataset1.addSeries(this.c.temperature);
        JFreeChart chart = ChartFactory.createTimeSeriesChart("miniDOT Logger Measurements", "Local Time", "Temperature (deg C)", dataset1, true, true, false);
        chart.addSubtitle(new TextTitle(this.c.SN));
        XYPlot plot = (XYPlot)chart.getPlot();
        plot.setOrientation(PlotOrientation.VERTICAL);
        plot.setDomainPannable(true);
        plot.setRangePannable(true);
        plot.getRangeAxis().setFixedDimension(15.0);
        NumberAxis axis2 = new NumberAxis("DO (mg/l)");
        axis2.setFixedDimension(10.0);
        axis2.setAutoRangeIncludesZero(false);
        plot.setRangeAxis(1, axis2);
        plot.setRangeAxisLocation(1, AxisLocation.BOTTOM_OR_LEFT);
        TimeSeriesCollection dataset2 = new TimeSeriesCollection();
        dataset2.addSeries(this.c.DO);
        plot.setDataset(1, dataset2);
        plot.mapDatasetToRangeAxis(1, 1);
        StandardXYItemRenderer renderer2 = new StandardXYItemRenderer();
        plot.setRenderer(1, renderer2);
        NumberAxis axis3 = new NumberAxis("DOSat (%)");
        plot.setRangeAxis(2, axis3);
        TimeSeriesCollection dataset3 = new TimeSeriesCollection();
        dataset3.addSeries(this.c.DOSat);
        plot.setDataset(2, dataset3);
        plot.mapDatasetToRangeAxis(2, 2);
        StandardXYItemRenderer renderer3 = new StandardXYItemRenderer();
        plot.setRenderer(2, renderer3);
        StandardXYItemRenderer renderer4 = null;
        NumberAxis axis4 = null;
        axis4 = new NumberAxis("Q ()");
        plot.setRangeAxis(3, axis4);
        TimeSeriesCollection dataset4 = new TimeSeriesCollection();
        dataset4.addSeries(this.c.Q);
        plot.setDataset(3, dataset4);
        plot.mapDatasetToRangeAxis(3, 3);
        renderer4 = new StandardXYItemRenderer();
        plot.setRenderer(3, renderer4);
        StandardXYItemRenderer renderer5 = null;
        NumberAxis axis5 = null;
        axis5 = new NumberAxis("Battery (Volt)");
        plot.setRangeAxis(4, axis5);
        TimeSeriesCollection dataset5 = new TimeSeriesCollection();
        dataset5.addSeries(this.c.battery);
        plot.setDataset(4, dataset5);
        plot.mapDatasetToRangeAxis(4, 4);
        renderer5 = new StandardXYItemRenderer();
        plot.setRenderer(4, renderer5);
        ChartUtilities.applyCurrentTheme(chart);
        plot.getRenderer().setSeriesPaint(0, Color.black);
        renderer2.setSeriesPaint(0, Color.red);
        axis2.setLabelPaint(Color.red);
        axis2.setTickLabelPaint(Color.red);
        renderer3.setSeriesPaint(0, Color.blue);
        axis3.setLabelPaint(Color.blue);
        axis3.setTickLabelPaint(Color.blue);
        renderer4.setSeriesPaint(0, Color.green);
        axis4.setLabelPaint(Color.green);
        axis4.setTickLabelPaint(Color.green);
        renderer5.setSeriesPaint(0, Color.orange);
        axis5.setLabelPaint(Color.orange);
        axis5.setTickLabelPaint(Color.orange);
        return chart;
    }

    public JPanel createDemoPanel() {
        JFreeChart chart = this.createChart();
        ChartPanel panel = new ChartPanel(chart);
        panel.setMouseWheelEnabled(true);
        return panel;
    }

    private void updateProgress(final boolean value) {
        Runnable dorun = new Runnable(){

            public void run() {
                Plot.this.mpb.setIndeterminate(value);
            }
        };
        try {
            SwingUtilities.invokeLater(dorun);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

