/*
 * Decompiled with CFR 0.152.
 */
package com.pme.control;

import com.pme.control.Concatenate;
import com.pme.control.Main;
import com.pme.control.Plot;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import org.jfree.ui.RefineryUtilities;

public class MainJFrame
extends JFrame {
    private JRadioButton BPRadioButton;
    private JRadioButton ElevationRadioButton;
    private ButtonGroup buttonGroup1;
    private JFileChooser dataFileChooser;
    private JFormattedTextField jElevationFormattedTextField;
    private JButton jImportButton;
    private JLabel jImportLabel;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JButton jProcessButton;
    private JProgressBar jProgressBar;
    private JFormattedTextField jSalinityFormattedTextField;

    public MainJFrame() {
        int i;
        this.initComponents();
        this.getContentPane().setBackground(Color.white);
        this.setTitle("miniDOT Plot Rev " + Main.Revision);
        String workingFolder = System.getProperty("user.dir");
        System.out.println("Working directory: " + workingFolder);
        File measurementsFolder = new File(workingFolder);
        String[] measurementFilesAndMaybeOthers = measurementsFolder.list();
        for (i = 0; !(i >= measurementFilesAndMaybeOthers.length || measurementFilesAndMaybeOthers[i].contains("7392-") || measurementFilesAndMaybeOthers[i].contains("7450-") || measurementFilesAndMaybeOthers[i].contains("7405-")); ++i) {
        }
        if (i < measurementFilesAndMaybeOthers.length) {
            this.jImportLabel.setText(workingFolder + File.separatorChar + measurementFilesAndMaybeOthers[i]);
            this.jProcessButton.setEnabled(true);
        } else {
            this.jImportLabel.setText("none selected");
            this.jProcessButton.setEnabled(false);
        }
    }

    private void initComponents() {
        this.dataFileChooser = new JFileChooser();
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel3 = new JLabel();
        this.jImportButton = new JButton();
        this.jProcessButton = new JButton();
        this.jImportLabel = new JLabel();
        this.jProgressBar = new JProgressBar();
        this.jElevationFormattedTextField = new JFormattedTextField();
        this.jLabel4 = new JLabel();
        this.jSalinityFormattedTextField = new JFormattedTextField();
        this.ElevationRadioButton = new JRadioButton();
        this.BPRadioButton = new JRadioButton();
        this.jLabel2 = new JLabel();
        this.setDefaultCloseOperation(3);
        this.setBackground(new Color(255, 255, 255));
        this.jLabel3.setText("Surface Elevation (meters)");
        this.jImportButton.setText("Select DATA Folder");
        this.jImportButton.setToolTipText("Select 'Data' folder containing miniDOT Logger files.");
        this.jImportButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainJFrame.this.jImportButtonActionPerformed(evt);
            }
        });
        this.jProcessButton.setText("Plot");
        this.jProcessButton.setToolTipText("Read files, create plot, create concatenated file.");
        this.jProcessButton.setEnabled(false);
        this.jProcessButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainJFrame.this.jProcessButtonActionPerformed(evt);
            }
        });
        this.jImportLabel.setText("(none selected)");
        this.jImportLabel.setToolTipText("The location of miniDOT Logger files.");
        this.jElevationFormattedTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0.00", new DecimalFormatSymbols(Locale.US)))));
        this.jElevationFormattedTextField.setText("0.00");
        this.jElevationFormattedTextField.setToolTipText("Enter surface elevation above sea level.  Used to compute oxygen saturation.");
        this.jLabel4.setText("Salinity (ppt)");
        this.jSalinityFormattedTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0.00", new DecimalFormatSymbols(Locale.US)))));
        this.jSalinityFormattedTextField.setText("0.00");
        this.jSalinityFormattedTextField.setToolTipText("Enter water salinity in ppt for DO saturation calculation");
        this.ElevationRadioButton.setBackground(new Color(255, 255, 255));
        this.buttonGroup1.add(this.ElevationRadioButton);
        this.ElevationRadioButton.setSelected(true);
        this.ElevationRadioButton.setText("Elevation");
        this.ElevationRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainJFrame.this.ElevationRadioButtonActionPerformed(evt);
            }
        });
        this.BPRadioButton.setBackground(new Color(255, 255, 255));
        this.buttonGroup1.add(this.BPRadioButton);
        this.BPRadioButton.setText("Barometric Pressure");
        this.BPRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainJFrame.this.BPRadioButtonActionPerformed(evt);
            }
        });
        this.jLabel2.setIcon(new ImageIcon(this.getClass().getResource("/com/pme/resources/PME logo.jpg")));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2, -2, 313, -2).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jLabel4).addComponent(this.jImportButton).addComponent(this.jProcessButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jImportLabel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jProgressBar, -2, 218, -2).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jSalinityFormattedTextField, GroupLayout.Alignment.LEADING, 0, 1, Short.MAX_VALUE).addComponent(this.jElevationFormattedTextField, GroupLayout.Alignment.LEADING, -2, 73, -2)).addGap(34, 34, 34).addComponent(this.ElevationRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.BPRadioButton))).addGap(0, 0, Short.MAX_VALUE))))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2, -2, 57, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jElevationFormattedTextField, -2, -1, -2).addComponent(this.ElevationRadioButton).addComponent(this.BPRadioButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jSalinityFormattedTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jImportButton).addComponent(this.jImportLabel, -2, 19, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jProcessButton).addComponent(this.jProgressBar, -2, -1, -2)).addContainerGap(17, Short.MAX_VALUE)));
        this.pack();
    }

    private void jImportButtonActionPerformed(ActionEvent evt) {
        this.dataFileChooser.setFileSelectionMode(1);
        this.dataFileChooser.setDialogTitle("Select miniDOT DATA folder");
        int returnVal = this.dataFileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            File file = this.dataFileChooser.getSelectedFile();
            File d = this.dataFileChooser.getCurrentDirectory();
            this.jImportLabel.setText(d.getPath() + File.separatorChar + file.getName());
            this.jProcessButton.setEnabled(true);
        }
        if (returnVal == 1) {
            this.jImportLabel.setText("(canceled)");
            this.jProcessButton.setEnabled(false);
        }
    }

    private void jProcessButtonActionPerformed(ActionEvent evt) {
        final MainJFrame mjf = this;
        this.jProcessButton.setEnabled(false);
        final double pressure = this.ElevationRadioButton.isSelected() ? Math.exp(5.25 * Math.log(1.0 - Double.parseDouble(this.jElevationFormattedTextField.getText()) / 44300.0)) * 101325.0 : Double.parseDouble(this.jElevationFormattedTextField.getText()) * 100.0;
        Runnable myRunnable = new Runnable(){

            public void run() {
                Concatenate myc = new Concatenate(MainJFrame.this.jProgressBar, MainJFrame.this.jImportLabel.getText(), pressure, Double.parseDouble(MainJFrame.this.jSalinityFormattedTextField.getText()));
                try {
                    myc.Concatenate();
                }
                catch (IOException e) {
                    System.out.println("IOException: " + e);
                    JOptionPane.showMessageDialog(mjf, "IOException: " + e, "miniDOT Plot Error", 0);
                    System.exit(0);
                }
                catch (NumberFormatException n) {
                    System.out.println("Number format error " + n);
                    JOptionPane.showMessageDialog(mjf, "Number Format Error: " + n, "miniDOT Plot Error", 0);
                    System.exit(0);
                }
                try {
                    Plot demo = new Plot(MainJFrame.this.jProgressBar, "miniDOT Plot Rev " + Main.Revision, myc);
                    demo.pack();
                    RefineryUtilities.centerFrameOnScreen(demo);
                    demo.setVisible(true);
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(mjf, "CatPlot I/O error: " + e, "miniDOT Plot Error", 0);
                    System.out.println("CatPlot error: " + e);
                    System.exit(0);
                }
                Runnable dorun = new Runnable(){

                    public void run() {
                        MainJFrame.this.jProcessButton.setEnabled(true);
                    }
                };
                try {
                    SwingUtilities.invokeLater(dorun);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        Thread thread = new Thread(myRunnable);
        thread.start();
    }

    private void ElevationRadioButtonActionPerformed(ActionEvent evt) {
        this.jLabel3.setText("Surface Elevation   (meters)");
        this.jElevationFormattedTextField.setText("0.00");
    }

    private void BPRadioButtonActionPerformed(ActionEvent evt) {
        this.jLabel3.setText("Barometric Pressure (mbar)");
        this.jElevationFormattedTextField.setText("1013.0");
    }
}

