/*
 * Decompiled with CFR 0.152.
 */
package Hid;

import com.codeminders.hidapi.ClassPathLibraryLoader;
import com.codeminders.hidapi.HIDDevice;
import com.codeminders.hidapi.HIDDeviceInfo;
import com.codeminders.hidapi.HIDManager;
import java.io.IOException;

public class HidInterface {
    private boolean doPrint = false;
    private static final int TI_EXAMPLE_REPORT_ID = 63;
    private static final String MINIDOT = "MINIDOT";
    private static final long READ_UPDATE_DELAY_MS = 50L;
    private static final int BUFSIZE = 2048;
    private HIDManager hidManager;
    private HIDDeviceInfo[] devinfo = null;
    private HIDDevice device = null;

    public HidInterface() throws IOException {
        if (!ClassPathLibraryLoader.loadNativeHIDLibrary()) {
            throw new IOException("Unable to load HID library");
        }
        this.hidManager = HIDManager.getInstance();
        if (this.hidManager == null) {
            throw new IOException("Unable to obtain HID manager");
        }
        this.devinfo = this.hidManager.listDevices();
        if (this.devinfo == null || this.devinfo.length == 0) {
            throw new IOException("No HID devices");
        }
    }

    public void connect() throws IOException {
        for (int i = 0; i < this.devinfo.length; ++i) {
            if (this.devinfo[i].getProduct_string() == null || !this.devinfo[i].getProduct_string().contains(MINIDOT)) continue;
            this.device = this.hidManager.openByPath(this.devinfo[i].getPath());
        }
        if (this.device == null) {
            throw new IOException("No miniDOT HID devices found");
        }
    }

    public HIDDeviceInfo[] getHIDDeviceInfo() {
        return this.devinfo;
    }

    public void printDevices() throws IOException {
        for (int i = 0; i < this.devinfo.length; ++i) {
            System.out.println("device " + i + "  Productstring: " + this.devinfo[i].getProduct_string());
            System.out.println("device " + i + "  Path: " + this.devinfo[i].getPath());
            System.out.println("device " + i + "  Vendor: " + this.devinfo[i].getVendor_id());
            System.out.println("device " + i + "  Mfgr: " + this.devinfo[i].getManufacturer_string());
            System.out.println("device " + i + "  Product: " + this.devinfo[i].getProduct_id());
        }
    }

    private String receive() throws IOException {
        byte[] buf = new byte[2048];
        String instr = "";
        block0: while (true) {
            this.device.read(buf);
            if (buf[0] != 63) {
                throw new IOException("wrong report");
            }
            int i = 0;
            while (true) {
                if (i >= buf[1]) continue block0;
                if (buf[i + 2] == 0) {
                    if (this.doPrint) {
                        System.out.println("received:" + instr);
                    }
                    if (instr.contains("????")) {
                        throw new IOException("Logger responds: ????");
                    }
                    return instr;
                }
                instr = instr + (char)buf[i + 2];
                ++i;
            }
            break;
        }
    }

    public void release() throws IOException {
        this.hidManager.release();
    }

    public void send(String s) throws IOException {
        if (this.doPrint) {
            System.out.println("Sending full string: " + s + " Length: " + s.length());
        }
        String tem = null;
        s = s + '\u0000';
        while (s.length() > 0) {
            tem = s.length() >= 62 ? s.substring(0, 62) : s;
            s = s.substring(tem.length());
            byte[] arr = new byte[2 + tem.length()];
            arr[0] = 63;
            arr[1] = (byte)tem.length();
            for (int i = 0; i < tem.length(); ++i) {
                arr[2 + i] = (byte)tem.charAt(i);
            }
            this.device.write(arr);
        }
    }

    public void setVerbose(boolean verbose) {
        this.doPrint = verbose;
    }

    public synchronized String transact(String s) throws IOException {
        this.send(s);
        return this.receive();
    }
}

