/*
 * Decompiled with CFR 0.152.
 */
package Device;

import Hid.HidInterface;
import java.io.IOException;

public class Mission {
    public static final String Rev = "1.00";
    private final HidInterface intf;
    public long timeOfLastCalibration;
    public int mode;
    public double[] CCoef = new double[12];
    public double[] MagCoef = new double[9];
    public double[] TCoef = new double[5];
    public double[] ZCoef = new double[2];
    public static final int CALMODE = 0;
    public static final int NORMALMODE = 1;
    public static final int FASTMODE = 2;
    public static final int SLOWMODE = 3;
    public static final int ACTIVATE_DC = 0;
    public static final int ACTIVATE_AC = 1;
    public static final int DEACTIVATE = 2;

    public Mission(HidInterface intf) throws IOException {
        this.intf = intf;
    }

    public void getAll() throws IOException {
        this.timeOfLastCalibration = this.getCalTime();
        this.mode = this.getCalFlag();
        this.CCoef = this.getCoef("CCOEF");
        this.MagCoef = this.getCoef("MAGCOEF");
        this.TCoef = this.getCoef("TCOEF");
        this.ZCoef = this.getCoef("ZCOEF");
    }

    public long getCalTime() throws IOException {
        return Integer.parseInt(this.intf.transact("CALTIME?"));
    }

    public int getCalFlag() throws IOException {
        return Integer.parseInt(this.intf.transact("MODE?"));
    }

    private double[] getCoef(String coeftype) throws IOException {
        String ss = this.intf.transact(coeftype + "?");
        String[] ps = ss.split(",");
        double[] c = new double[ps.length];
        for (int i = 0; i < ps.length; ++i) {
            c[i] = Double.parseDouble(ps[i]);
        }
        return c;
    }

    public void measureBegin() throws IOException {
        this.intf.transact("MBEGIN");
    }

    public void measureEnd() throws IOException {
        this.intf.transact("MEND");
    }

    public String measure() throws IOException {
        return this.intf.transact("MEASURE");
    }

    public void performDOTest(int test) throws IOException {
        this.intf.transact("MTEST " + test);
    }

    public void setCalTime(long caltime) throws IOException {
        this.intf.transact("CALTIME " + caltime);
    }

    public void setMode(int mode) throws IOException {
        this.intf.transact("MODE " + mode);
    }

    public void setCCOEF(double[] c) throws IOException {
        this.setCoef("CCOEF", c);
    }

    public void setMAGCOEF(double[] c) throws IOException {
        this.setCoef("MAGCOEF", c);
    }

    public void setTCOEF(double[] c) throws IOException {
        this.setCoef("TCOEF", c);
    }

    public void setZCOEF(double[] c) throws IOException {
        this.setCoef("ZCOEF", c);
    }

    private void setCoef(String coeftype, double[] c) throws IOException {
        String s = coeftype + " ";
        for (int i = 0; i < c.length; ++i) {
            s = i < c.length - 1 ? s + String.format("%1$12.8e", c[i]) + ',' : s + String.format("%1$12.8e", c[i]);
        }
        this.intf.transact(s);
    }
}

