/*
 * Decompiled with CFR 0.152.
 */
package Device;

import Hid.HidInterface;
import java.io.IOException;

public class Logger {
    public static final String Rev = "1.01";
    private final HidInterface intf;
    public String SN;
    public String softwareRevision;
    public int sampleInterval;
    public Double MainBatteryVoltage;
    public Double BackupBatteryVoltage;
    public Double Temperature;
    public double clockFreqAdjustment;
    public long clockDatum;

    public Logger(HidInterface intf) throws IOException {
        this.intf = intf;
    }

    public Double adjustClockCalibration(int timeerror) throws IOException {
        long measurementinterval = this.getTime() - this.getClockDatum();
        if (measurementinterval < 500000L) {
            throw new IOException("Insufficient elapsed time (" + measurementinterval + " (sec))");
        }
        double observedErrorPpm = (double)timeerror / (double)measurementinterval * 1000000.0;
        double currentAdjPpm = this.getClockFrequencyAdjustment();
        double unadjustedErrorPpm = observedErrorPpm - currentAdjPpm;
        double adjustmentrequired = -unadjustedErrorPpm;
        int adjustment = adjustmentrequired >= 0.0 ? (int)Math.round(adjustmentrequired / 4.34) : (int)Math.round(adjustmentrequired / 2.17);
        if (Math.abs(adjustment) >= 64) {
            throw new IOException("Insufficent adjustability (" + adjustment + " (ppm))");
        }
        this.setClockFreqAdjustment(adjustmentrequired);
        return adjustmentrequired;
    }

    public void bootstrap() throws IOException {
        this.intf.send("BOOTSTRAP");
    }

    public double measureBattery() throws IOException {
        String ss = this.intf.transact("BATTERY?");
        String[] ps = ss.split(",");
        return Double.parseDouble(ps[0]);
    }

    private void measureSystem() throws IOException {
        String ss = this.intf.transact("BATTERY?");
        String[] ps = ss.split(",");
        this.MainBatteryVoltage = Double.parseDouble(ps[0]);
        this.BackupBatteryVoltage = Double.parseDouble(ps[1]);
        this.Temperature = Double.parseDouble(ps[2]);
    }

    public double measureTemperature() throws IOException {
        String ss = this.intf.transact("BATTERY?");
        String[] ps = ss.split(",");
        return Double.parseDouble(ps[2]);
    }

    public void getAll() throws IOException {
        this.SN = this.getSN();
        this.softwareRevision = this.getSoftwareRevision();
        this.sampleInterval = this.getSampleInterval();
        this.measureSystem();
        this.clockFreqAdjustment = this.getClockFrequencyAdjustment();
        this.clockDatum = this.getClockDatum();
    }

    public double getClockFrequencyAdjustment() throws IOException {
        return Double.parseDouble(this.intf.transact("CLOCKCAL?"));
    }

    public long getClockDatum() throws IOException {
        return Long.parseLong(this.intf.transact("CLOCKDATUM?"));
    }

    public int getSampleInterval() throws IOException {
        return Integer.parseInt(this.intf.transact("SAMPLEINTERVAL?"));
    }

    public String getSoftwareRevision() throws IOException {
        return this.intf.transact("OSREV?");
    }

    public String getSN() throws IOException {
        return this.intf.transact("SN?");
    }

    public long getTime() throws IOException {
        return Long.parseLong(this.intf.transact("TIME?"));
    }

    public void print() {
        System.out.println("SN: " + this.SN + " OSRev: " + this.softwareRevision);
        System.out.println("Sample Interval: " + this.sampleInterval);
        System.out.println("Main Bat: " + this.MainBatteryVoltage + " BU Bat: " + this.BackupBatteryVoltage + " Temperature: " + this.Temperature);
        System.out.println("Clock Freq Adj: " + this.clockFreqAdjustment + " Datum: " + this.clockDatum);
    }

    public void setClockFreqAdjustment(double ppm) throws IOException {
        this.intf.transact("CLOCKCAL " + ppm);
    }

    public void setSampleInterval(int sampleinterval) throws IOException {
        this.intf.transact("SAMPLEINTERVAL " + sampleinterval);
    }

    public void setSN(String sn) throws IOException {
        this.intf.transact("SN" + sn);
    }

    public void setTime(long time) throws IOException {
        this.intf.transact("TIME " + time);
    }
}

