/*
 * Decompiled with CFR 0.152.
 */
package Control;

import Device.Logger;
import Device.Mission;
import Hid.HidInterface;
import Time.ConvertTime;
import Time.SntpClient;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.List;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;

public class MainJFrame
extends JFrame {
    private HidInterface hidinterface = null;
    private Mission mission = null;
    private Logger logger = null;
    private SwingWorker<Boolean, Long> timeworker;
    private Double Q;
    private JButton ConnectButton;
    private JLabel jBUBatLabel;
    private JLabel jBUBatUnit;
    private JLabel jBUBatValue;
    private JLabel jBVLabel;
    private JLabel jBVUnit;
    private JLabel jBVValue;
    private JLabel jCalDateLabel;
    private JLabel jCalDateValue;
    private JLabel jClockAdjLabel;
    private JLabel jClockAdjUnit;
    private JLabel jClockAdjValue;
    private JPanel jControlLoggerPanel;
    private JLabel jDateLabel;
    private JLabel jDateUnit;
    private JLabel jDateValue;
    private JLabel jLabel12;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JLabel jQLabel;
    private JLabel jQValue;
    private JLabel jSNLabel;
    private JLabel jSNValue;
    private JLabel jSampleIntervalLabel;
    private JLabel jSampleIntervalSetIcon;
    private JLabel jSampleIntervalUnit;
    private JLabel jSampleIntervalValue;
    private JTextField jSetSampleIntervalTextBox;
    private JLabel jSetSampleIntervalUnit;
    private JLabel jSoftRevLabel;
    private JLabel jSoftRevValue;
    private JLabel jTemperatureLabel;
    private JLabel jTemperatureUnit;
    private JLabel jTemperatureValue;
    private JLabel jTimeErrorLabel;
    private JLabel jTimeErrorUnit;
    private JLabel jTimeErrorValue;
    private JLabel jTimeSetIcon;
    private JLabel jTimeSetLabel;
    private JButton setSampleIntervalButton;

    public MainJFrame() {
        this.initComponents();
        this.getContentPane().setBackground(Color.white);
        this.setTitle("miniDOTControl Rev 1.06");
        this.jDateUnit.setText("(" + TimeZone.getDefault().getDisplayName() + ")");
        this.jSNLabel.setEnabled(false);
        this.jSNValue.setEnabled(false);
        this.jSoftRevLabel.setEnabled(false);
        this.jSoftRevValue.setEnabled(false);
        this.jCalDateLabel.setEnabled(false);
        this.jCalDateValue.setEnabled(false);
        this.jDateLabel.setEnabled(false);
        this.jDateValue.setEnabled(false);
        this.jDateUnit.setEnabled(false);
        this.jSampleIntervalLabel.setEnabled(false);
        this.jSampleIntervalValue.setEnabled(false);
        this.jSampleIntervalUnit.setEnabled(false);
        this.jBVLabel.setEnabled(false);
        this.jBVValue.setEnabled(false);
        this.jBVUnit.setEnabled(false);
        this.jBUBatLabel.setEnabled(false);
        this.jBUBatValue.setEnabled(false);
        this.jBUBatUnit.setEnabled(false);
        this.jTemperatureLabel.setEnabled(false);
        this.jTemperatureValue.setEnabled(false);
        this.jTemperatureUnit.setEnabled(false);
        this.jTimeErrorLabel.setEnabled(false);
        this.jTimeErrorValue.setEnabled(false);
        this.jTimeErrorUnit.setEnabled(false);
        this.jClockAdjLabel.setEnabled(false);
        this.jClockAdjValue.setEnabled(false);
        this.jClockAdjUnit.setEnabled(false);
        this.jQLabel.setEnabled(false);
        this.jQValue.setEnabled(false);
        this.jTimeSetLabel.setVisible(false);
        this.jTimeSetIcon.setVisible(false);
        this.jSampleIntervalSetIcon.setVisible(false);
        this.jSetSampleIntervalTextBox.setEnabled(false);
        this.jSetSampleIntervalUnit.setEnabled(false);
        this.jControlLoggerPanel.setEnabled(false);
        this.setSampleIntervalButton.setEnabled(false);
    }

    private void initComponents() {
        this.jLabel12 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jPanel1 = new JPanel();
        this.ConnectButton = new JButton();
        this.jSNLabel = new JLabel();
        this.jSNValue = new JLabel();
        this.jSoftRevLabel = new JLabel();
        this.jSoftRevValue = new JLabel();
        this.jTimeErrorLabel = new JLabel();
        this.jTimeErrorValue = new JLabel();
        this.jTimeErrorUnit = new JLabel();
        this.jBVLabel = new JLabel();
        this.jBVValue = new JLabel();
        this.jBVUnit = new JLabel();
        this.jCalDateLabel = new JLabel();
        this.jCalDateValue = new JLabel();
        this.jTemperatureLabel = new JLabel();
        this.jTemperatureValue = new JLabel();
        this.jTemperatureUnit = new JLabel();
        this.jDateLabel = new JLabel();
        this.jDateValue = new JLabel();
        this.jDateUnit = new JLabel();
        this.jClockAdjLabel = new JLabel();
        this.jClockAdjValue = new JLabel();
        this.jClockAdjUnit = new JLabel();
        this.jTimeSetLabel = new JLabel();
        this.jTimeSetIcon = new JLabel();
        this.jSampleIntervalLabel = new JLabel();
        this.jSampleIntervalValue = new JLabel();
        this.jSampleIntervalUnit = new JLabel();
        this.jBUBatLabel = new JLabel();
        this.jBUBatValue = new JLabel();
        this.jBUBatUnit = new JLabel();
        this.jQLabel = new JLabel();
        this.jQValue = new JLabel();
        this.jControlLoggerPanel = new JPanel();
        this.setSampleIntervalButton = new JButton();
        this.jSetSampleIntervalTextBox = new JTextField();
        this.jSetSampleIntervalUnit = new JLabel();
        this.jSampleIntervalSetIcon = new JLabel();
        this.jLabel12.setText("jLabel12");
        this.setDefaultCloseOperation(3);
        this.jLabel2.setIcon(new ImageIcon(this.getClass().getResource("/Resources/PME logo.jpg")));
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Logger Status"));
        this.ConnectButton.setText("Connect");
        this.ConnectButton.setToolTipText("Click to connect to logger via USB");
        this.ConnectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainJFrame.this.ConnectButtonActionPerformed(evt);
            }
        });
        this.jSNLabel.setText("Serial Number:");
        this.jSNLabel.setToolTipText("Serial number of connected logger");
        this.jSNValue.setText("(pending)");
        this.jSoftRevLabel.setText("Software Revision:");
        this.jSoftRevLabel.setToolTipText("Revision level of logger internal software");
        this.jSoftRevValue.setText("(pending)");
        this.jTimeErrorLabel.setText("Time Error at Connect:");
        this.jTimeErrorLabel.setToolTipText("Difference of logger time from  true time at time of connection");
        this.jTimeErrorValue.setText("(pending)");
        this.jTimeErrorUnit.setText("(second)");
        this.jBVLabel.setText("Battery Voltage:");
        this.jBVLabel.setToolTipText("Voltage of logger battery");
        this.jBVValue.setText("(pending)");
        this.jBVUnit.setText("(Volt)");
        this.jCalDateLabel.setText("Sensor Calibration Date:");
        this.jCalDateLabel.setToolTipText("Date of last calibration of sensor");
        this.jCalDateValue.setText("(pending)");
        this.jTemperatureLabel.setText("Temperature:");
        this.jTemperatureLabel.setToolTipText("Temperature of logger");
        this.jTemperatureValue.setText("(pending)");
        this.jTemperatureUnit.setText("(deg C)");
        this.jDateLabel.setText("Current Logger Time:");
        this.jDateLabel.setToolTipText("Present logger date and time");
        this.jDateValue.setText("(pending)");
        this.jDateUnit.setText("(UTC)");
        this.jClockAdjLabel.setText("Clock Speed Adjusted:");
        this.jClockAdjLabel.setToolTipText("Adjustment made to logger clock speed");
        this.jClockAdjValue.setText("(pending)");
        this.jClockAdjUnit.setText("(ppm)");
        this.jTimeSetLabel.setText("Time Set");
        this.jTimeSetIcon.setIcon(new ImageIcon(this.getClass().getResource("/Resources/tic.jpg")));
        this.jSampleIntervalLabel.setText("Sample Interval:");
        this.jSampleIntervalValue.setText("(pending)");
        this.jSampleIntervalUnit.setText("(minute)");
        this.jBUBatLabel.setText("Backup Battery Voltage:");
        this.jBUBatValue.setText("(pending)");
        this.jBUBatUnit.setText("(Volt)");
        this.jQLabel.setText("Measurement Quality:");
        this.jQValue.setText("(pending)");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSNLabel).addComponent(this.jSoftRevLabel).addComponent(this.jCalDateLabel).addComponent(this.jTimeErrorLabel).addComponent(this.jBVLabel).addComponent(this.ConnectButton).addComponent(this.jDateLabel).addComponent(this.jClockAdjLabel).addComponent(this.jSampleIntervalLabel).addComponent(this.jTemperatureLabel).addComponent(this.jBUBatLabel).addComponent(this.jQLabel)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jTemperatureValue).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jTemperatureUnit)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jSampleIntervalValue).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jSampleIntervalUnit)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jBVValue).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jBVUnit)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jCalDateValue, -1, -1, Short.MAX_VALUE).addGap(34, 34, 34)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jClockAdjValue).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jClockAdjUnit)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jTimeErrorValue).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jTimeErrorUnit)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jTimeSetIcon).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTimeSetLabel)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jDateValue, -2, 136, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jDateUnit, -1, -1, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jBUBatValue).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jBUBatUnit)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSNValue).addComponent(this.jSoftRevValue).addComponent(this.jQValue)).addGap(0, 249, Short.MAX_VALUE))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.ConnectButton, -2, 23, -2)).addComponent(this.jTimeSetLabel).addComponent(this.jTimeSetIcon)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSNLabel).addComponent(this.jSNValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSoftRevLabel).addComponent(this.jSoftRevValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCalDateLabel).addComponent(this.jCalDateValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jDateLabel).addComponent(this.jDateUnit).addComponent(this.jDateValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSampleIntervalLabel).addComponent(this.jSampleIntervalValue).addComponent(this.jSampleIntervalUnit)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jBVLabel).addComponent(this.jBVUnit).addComponent(this.jBVValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jBUBatLabel).addComponent(this.jBUBatValue).addComponent(this.jBUBatUnit)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTemperatureLabel).addComponent(this.jTemperatureValue).addComponent(this.jTemperatureUnit)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTimeErrorValue, -2, 14, -2).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTimeErrorLabel).addComponent(this.jTimeErrorUnit))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jClockAdjUnit).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jClockAdjLabel).addComponent(this.jClockAdjValue))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jQLabel).addComponent(this.jQValue)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jControlLoggerPanel.setBackground(new Color(255, 255, 255));
        this.jControlLoggerPanel.setBorder(BorderFactory.createTitledBorder("Control Logger"));
        this.setSampleIntervalButton.setText("Set Sample Interval");
        this.setSampleIntervalButton.setToolTipText("Click to send logger sample interval to logger");
        this.setSampleIntervalButton.setEnabled(false);
        this.setSampleIntervalButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainJFrame.this.setSampleIntervalButtonActionPerformed(evt);
            }
        });
        this.jSetSampleIntervalTextBox.setText("(pending)");
        this.jSetSampleIntervalTextBox.setToolTipText("Desired sample interval");
        this.jSetSampleIntervalTextBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainJFrame.this.setSampleIntervalButtonActionPerformed(evt);
            }
        });
        this.jSetSampleIntervalUnit.setText("(minute)");
        this.jSampleIntervalSetIcon.setIcon(new ImageIcon(this.getClass().getResource("/Resources/tic.jpg")));
        GroupLayout jControlLoggerPanelLayout = new GroupLayout(this.jControlLoggerPanel);
        this.jControlLoggerPanel.setLayout(jControlLoggerPanelLayout);
        jControlLoggerPanelLayout.setHorizontalGroup(jControlLoggerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jControlLoggerPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jSampleIntervalSetIcon).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.setSampleIntervalButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jSetSampleIntervalTextBox, -2, 62, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSetSampleIntervalUnit).addContainerGap()));
        jControlLoggerPanelLayout.setVerticalGroup(jControlLoggerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jControlLoggerPanelLayout.createSequentialGroup().addContainerGap().addGroup(jControlLoggerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jControlLoggerPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.setSampleIntervalButton).addComponent(this.jSetSampleIntervalTextBox, -2, -1, -2).addComponent(this.jSetSampleIntervalUnit)).addComponent(this.jSampleIntervalSetIcon)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2, -1, 472, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jControlLoggerPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2, -2, 64, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jControlLoggerPanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void ConnectButtonActionPerformed(ActionEvent evt) {
        try {
            this.hidinterface = new HidInterface();
            this.hidinterface.connect();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Problem connecting to logger\nIs logger connected to USB?\nIs logger LED constantly on?\n" + e);
            return;
        }
        this.ConnectButton.setEnabled(false);
        this.ConnectButton.setText("Reading...");
        SwingWorker<Boolean, Void> systemworker = new SwingWorker<Boolean, Void>(){

            @Override
            protected Boolean doInBackground() {
                try {
                    MainJFrame.this.logger = new Logger(MainJFrame.this.hidinterface);
                    MainJFrame.this.mission = new Mission(MainJFrame.this.hidinterface);
                    MainJFrame.this.logger.getAll();
                    MainJFrame.this.mission.getAll();
                    if (((MainJFrame)MainJFrame.this).mission.mode == 0) {
                        ((MainJFrame)MainJFrame.this).mission.mode = 1;
                        ((MainJFrame)MainJFrame.this).logger.sampleInterval = 600;
                        MainJFrame.this.mission.setMode(((MainJFrame)MainJFrame.this).mission.mode);
                        MainJFrame.this.logger.setSampleInterval(((MainJFrame)MainJFrame.this).logger.sampleInterval);
                    }
                    MainJFrame.this.mission.measureBegin();
                    String[] tempstr = MainJFrame.this.mission.measure().split(",");
                    MainJFrame.this.mission.measureEnd();
                    MainJFrame.this.Q = Double.parseDouble(tempstr[4]);
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(MainJFrame.this, "Problem reading logger\nIs logger connected to USB?\nIs logger LED constantly on?\n" + e);
                    System.exit(-1);
                }
                return true;
            }

            @Override
            protected void done() {
                MainJFrame.this.jSNValue.setText(((MainJFrame)MainJFrame.this).logger.SN);
                MainJFrame.this.jSoftRevValue.setText(((MainJFrame)MainJFrame.this).logger.softwareRevision);
                MainJFrame.this.jCalDateValue.setText(new ConvertTime().dayFromTimeLocal(((MainJFrame)MainJFrame.this).mission.timeOfLastCalibration));
                MainJFrame.this.jBVValue.setText(String.format("%1$4.2f", ((MainJFrame)MainJFrame.this).logger.MainBatteryVoltage));
                MainJFrame.this.jBUBatValue.setText(String.format("%1$4.2f", ((MainJFrame)MainJFrame.this).logger.BackupBatteryVoltage));
                MainJFrame.this.jTemperatureValue.setText(String.format("%1$5.3f", ((MainJFrame)MainJFrame.this).logger.Temperature));
                if (MainJFrame.this.Q > 0.9) {
                    MainJFrame.this.jQValue.setForeground(Color.green);
                    MainJFrame.this.jQValue.setText("Good! (" + String.format("%1$5.3f", MainJFrame.this.Q) + ")");
                } else if (MainJFrame.this.Q > 0.75) {
                    MainJFrame.this.jQValue.setText("Fair (" + String.format("%1$5.3f", MainJFrame.this.Q) + ")");
                } else {
                    MainJFrame.this.jQValue.setForeground(Color.red);
                    MainJFrame.this.jQValue.setText("Poor! (" + String.format("%1$5.3f", MainJFrame.this.Q) + ")");
                }
                try {
                    MainJFrame.this.jDateValue.setText(new ConvertTime().dateFromTimeLocal(MainJFrame.this.logger.getTime()));
                    long UTCtime = SntpClient.getUTCTime();
                    int timeerror = (int)(MainJFrame.this.logger.getTime() - UTCtime);
                    MainJFrame.this.jTimeErrorValue.setText(Integer.toString(timeerror));
                    MainJFrame.this.jTimeErrorUnit.setText("(second)");
                    try {
                        double prevadj = ((MainJFrame)MainJFrame.this).logger.clockFreqAdjustment;
                        Double adjustmentrequired = MainJFrame.this.logger.adjustClockCalibration(timeerror);
                        MainJFrame.this.jClockAdjValue.setText(String.format("%1$3.0f", adjustmentrequired) + " (previous " + String.format("%1$3.0f", prevadj) + ")");
                        MainJFrame.this.jClockAdjUnit.setText("(ppm)");
                        MainJFrame.this.logger.setTime(UTCtime + 1L);
                        MainJFrame.this.jTimeSetLabel.setVisible(true);
                        MainJFrame.this.jTimeSetIcon.setVisible(true);
                    }
                    catch (IOException e) {
                        MainJFrame.this.jClockAdjValue.setText(e.getMessage());
                        MainJFrame.this.jClockAdjUnit.setText("");
                    }
                    MainJFrame.this.jTimeErrorLabel.setEnabled(true);
                    MainJFrame.this.jTimeErrorValue.setEnabled(true);
                    MainJFrame.this.jTimeErrorUnit.setEnabled(true);
                    MainJFrame.this.jClockAdjLabel.setEnabled(true);
                    MainJFrame.this.jClockAdjValue.setEnabled(true);
                    MainJFrame.this.jClockAdjUnit.setEnabled(true);
                }
                catch (IOException eio) {
                    MainJFrame.this.jTimeErrorValue.setText("No Internet Connection");
                    MainJFrame.this.jTimeErrorUnit.setVisible(false);
                    MainJFrame.this.jClockAdjValue.setText("No Internet Connection");
                    MainJFrame.this.jClockAdjUnit.setVisible(false);
                    MainJFrame.this.jTimeErrorLabel.setEnabled(false);
                    MainJFrame.this.jTimeErrorValue.setEnabled(false);
                    MainJFrame.this.jTimeErrorUnit.setEnabled(false);
                    MainJFrame.this.jClockAdjLabel.setEnabled(false);
                    MainJFrame.this.jClockAdjValue.setEnabled(false);
                    MainJFrame.this.jClockAdjUnit.setEnabled(false);
                }
                MainJFrame.this.jSNLabel.setEnabled(true);
                MainJFrame.this.jSNValue.setEnabled(true);
                MainJFrame.this.jSoftRevLabel.setEnabled(true);
                MainJFrame.this.jSoftRevValue.setEnabled(true);
                MainJFrame.this.jCalDateLabel.setEnabled(true);
                MainJFrame.this.jCalDateValue.setEnabled(true);
                MainJFrame.this.jDateLabel.setEnabled(true);
                MainJFrame.this.jDateValue.setEnabled(true);
                MainJFrame.this.jDateUnit.setEnabled(true);
                MainJFrame.this.jSampleIntervalLabel.setEnabled(true);
                MainJFrame.this.jSampleIntervalValue.setEnabled(true);
                MainJFrame.this.jSampleIntervalUnit.setEnabled(true);
                MainJFrame.this.jBVLabel.setEnabled(true);
                MainJFrame.this.jBVValue.setEnabled(true);
                MainJFrame.this.jBVUnit.setEnabled(true);
                MainJFrame.this.jBUBatLabel.setEnabled(true);
                MainJFrame.this.jBUBatValue.setEnabled(true);
                MainJFrame.this.jBUBatUnit.setEnabled(true);
                MainJFrame.this.jTemperatureLabel.setEnabled(true);
                MainJFrame.this.jTemperatureValue.setEnabled(true);
                MainJFrame.this.jTemperatureUnit.setEnabled(true);
                MainJFrame.this.jQLabel.setEnabled(true);
                MainJFrame.this.jQValue.setEnabled(true);
                switch (((MainJFrame)MainJFrame.this).mission.mode) {
                    case 0: {
                        MainJFrame.this.jSetSampleIntervalUnit.setText("(calibration)");
                        MainJFrame.this.jSetSampleIntervalTextBox.setText("CAL");
                        MainJFrame.this.jSampleIntervalValue.setText("CAL");
                        MainJFrame.this.jSetSampleIntervalUnit.setVisible(false);
                        MainJFrame.this.jSampleIntervalUnit.setVisible(false);
                        MainJFrame.this.jSetSampleIntervalTextBox.setEnabled(false);
                        MainJFrame.this.setSampleIntervalButton.setEnabled(false);
                        break;
                    }
                    case 2: {
                        MainJFrame.this.jSetSampleIntervalUnit.setText("(second)");
                        MainJFrame.this.jSampleIntervalUnit.setText("(second)");
                        MainJFrame.this.jSetSampleIntervalUnit.setEnabled(true);
                        MainJFrame.this.setSampleIntervalButton.setEnabled(true);
                        MainJFrame.this.jSetSampleIntervalTextBox.setText(Integer.toString(((MainJFrame)MainJFrame.this).logger.sampleInterval));
                        MainJFrame.this.jSampleIntervalValue.setText(Integer.toString(((MainJFrame)MainJFrame.this).logger.sampleInterval));
                        MainJFrame.this.jSetSampleIntervalTextBox.setEnabled(true);
                        MainJFrame.this.setSampleIntervalButton.setEnabled(true);
                        break;
                    }
                    case 1: {
                        MainJFrame.this.jSetSampleIntervalUnit.setText("(minute)");
                        MainJFrame.this.jSetSampleIntervalUnit.setEnabled(true);
                        MainJFrame.this.jSampleIntervalUnit.setText("(minute)");
                        MainJFrame.this.jSetSampleIntervalTextBox.setText(Integer.toString(((MainJFrame)MainJFrame.this).logger.sampleInterval / 60));
                        MainJFrame.this.jSampleIntervalValue.setText(Integer.toString(((MainJFrame)MainJFrame.this).logger.sampleInterval / 60));
                        MainJFrame.this.setSampleIntervalButton.setEnabled(true);
                        MainJFrame.this.jSetSampleIntervalTextBox.setEnabled(true);
                        MainJFrame.this.setSampleIntervalButton.setEnabled(true);
                        break;
                    }
                    case 3: {
                        MainJFrame.this.jSetSampleIntervalUnit.setText("(hour)");
                        MainJFrame.this.jSetSampleIntervalUnit.setEnabled(true);
                        MainJFrame.this.jSetSampleIntervalTextBox.setText(Integer.toString(((MainJFrame)MainJFrame.this).logger.sampleInterval / 3600));
                        MainJFrame.this.jSampleIntervalValue.setText(Integer.toString(((MainJFrame)MainJFrame.this).logger.sampleInterval / 3600));
                        MainJFrame.this.setSampleIntervalButton.setEnabled(true);
                        MainJFrame.this.jSetSampleIntervalTextBox.setEnabled(true);
                        MainJFrame.this.setSampleIntervalButton.setEnabled(true);
                    }
                }
                MainJFrame.this.jControlLoggerPanel.setEnabled(true);
                MainJFrame.this.ConnectButton.setBackground(Color.green);
                MainJFrame.this.ConnectButton.setText("Connected!");
                MainJFrame.this.createTimeWorker();
                MainJFrame.this.timeworker.execute();
            }
        };
        systemworker.execute();
    }

    private void setSampleIntervalButtonActionPerformed(ActionEvent evt) {
        try {
            int sampleInterval = Integer.parseInt(this.jSetSampleIntervalTextBox.getText());
            switch (this.mission.mode) {
                case 3: {
                    if (sampleInterval <= 24 && sampleInterval >= 1) {
                        this.logger.setSampleInterval(sampleInterval * 3600);
                        this.setSampleIntervalButton.setText("Interval now " + sampleInterval + " hours)");
                        break;
                    }
                    throw new NumberFormatException("Entry out of range!");
                }
                case 1: {
                    if (sampleInterval <= 60 && sampleInterval >= 1) {
                        this.logger.setSampleInterval(sampleInterval * 60);
                        this.setSampleIntervalButton.setText("Interval now " + sampleInterval + " minutes");
                        break;
                    }
                    throw new NumberFormatException("Entry out of range!");
                }
                case 2: {
                    if (sampleInterval <= 3600 && sampleInterval >= 5) {
                        this.logger.setSampleInterval(sampleInterval);
                        this.setSampleIntervalButton.setText("Interval now " + sampleInterval + " seconds");
                        break;
                    }
                    throw new NumberFormatException("Entry out of range!");
                }
            }
            this.jSampleIntervalValue.setText(this.jSetSampleIntervalTextBox.getText());
            this.jSampleIntervalSetIcon.setVisible(true);
        }
        catch (NumberFormatException e) {
            switch (this.mission.mode) {
                case 3: {
                    JOptionPane.showMessageDialog(this, "Please enter an interval between 1 and 24 hours.");
                    break;
                }
                case 1: {
                    JOptionPane.showMessageDialog(this, "Please enter an interval between 1 and 60 minutes.");
                    break;
                }
                case 2: {
                    JOptionPane.showMessageDialog(this, "Please enter an interval between 5 and 3600 seconds.");
                }
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Problem connecting to logger\nIs logger connected to USB?\nIs logger LED constantly on?\n" + e);
            System.exit(-1);
        }
    }

    private void createTimeWorker() {
        this.timeworker = new SwingWorker<Boolean, Long>(){

            @Override
            protected Boolean doInBackground() {
                while (!this.isCancelled()) {
                    try {
                        Long t = MainJFrame.this.logger.getTime();
                        this.publish(t);
                        Thread.sleep(100L);
                    }
                    catch (IOException e) {
                        JOptionPane.showMessageDialog(MainJFrame.this, "Time Thread problem reading logger\n" + e);
                        System.exit(-1);
                    }
                    catch (InterruptedException ee) {
                        JOptionPane.showMessageDialog(MainJFrame.this, "Problem with thread sleep" + ee);
                        System.exit(-1);
                    }
                }
                return true;
            }

            @Override
            protected void process(List<Long> chunks) {
                MainJFrame.this.jDateValue.setText(new ConvertTime().dateFromTimeLocal(chunks.get(chunks.size() - 1)));
            }
        };
    }
}

