/*
 * Decompiled with CFR 0.152.
 */
package com.pme.control;

import com.pme.channel.Battery;
import com.pme.channel.Channel;
import com.pme.channel.DO;
import com.pme.channel.DOSat;
import com.pme.channel.Q;
import com.pme.channel.Temperature;
import com.pme.channel.TimeAsDate;
import com.pme.channel.TimeAsUTCDate;
import com.pme.channel.TimeSeconds;
import com.pme.io.CatFile;
import com.pme.io.MeasurementFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class Concatenator {
    public String SN = null;
    private final String measurementsPath;
    private final double salinity;
    private final double pressure;
    private final JProgressBar mpb;
    private final double ep;
    private final boolean eorp;

    public Concatenator(JProgressBar mpb, String measurementsPath, double pressure, double salinity, double ep, boolean eorp) {
        this.measurementsPath = measurementsPath;
        this.salinity = salinity;
        this.pressure = pressure;
        this.mpb = mpb;
        this.ep = ep;
        this.eorp = eorp;
    }

    public void Concatenate() throws IOException, NumberFormatException {
        int i;
        MeasurementFile measurementFile = null;
        CatFile mycatf = null;
        ArrayList<Channel> ChannelArray = new ArrayList<Channel>();
        this.updateProgress(0);
        ChannelArray.add(new TimeSeconds());
        ChannelArray.add(new TimeAsUTCDate());
        ChannelArray.add(new TimeAsDate());
        ChannelArray.add(new Battery());
        ChannelArray.add(new Temperature());
        ChannelArray.add(new DO(this.salinity));
        ChannelArray.add(new DOSat(this.pressure, this.salinity));
        ChannelArray.add(new Q());
        File measurementsFolder = new File(this.measurementsPath);
        String[] measurementFilesAndMaybeOthers = measurementsFolder.list();
        int j = 0;
        for (i = 0; i < measurementFilesAndMaybeOthers.length; ++i) {
            if (!this.isMeasurementFile(measurementFilesAndMaybeOthers[i])) continue;
            ++j;
        }
        if (j == 0) {
            IOException mye = new IOException("No miniDOT .TXT files found");
            throw mye;
        }
        Object[] measurementFileNames = new String[j];
        j = 0;
        for (i = 0; i < measurementFilesAndMaybeOthers.length; ++i) {
            if (!this.isMeasurementFile(measurementFilesAndMaybeOthers[i])) continue;
            measurementFileNames[j] = measurementFilesAndMaybeOthers[i];
            ++j;
        }
        measurementFilesAndMaybeOthers = null;
        Arrays.sort(measurementFileNames);
        for (int fileindex = 0; fileindex < measurementFileNames.length; ++fileindex) {
            try {
                this.updateProgress((int)(100.0 * (double)fileindex / (double)measurementFileNames.length));
                System.out.println("processing file: " + (String)measurementFileNames[fileindex]);
                measurementFile = new MeasurementFile(this.measurementsPath, (String)measurementFileNames[fileindex]);
                if (measurementFile.length == 0L) continue;
                if (this.SN == null) {
                    this.SN = measurementFile.sensorSN;
                }
                if (!this.SN.contentEquals(measurementFile.sensorSN)) {
                    System.out.println("Incorrect sensor: " + this.SN);
                    continue;
                }
                for (i = 0; i < ChannelArray.size(); ++i) {
                    ((Channel)ChannelArray.get((int)i)).currentMeasurementFile = measurementFile;
                }
                if (mycatf == null) {
                    mycatf = new CatFile(this.measurementsPath, measurementFile.sensorSN);
                    mycatf.printHeader();
                    mycatf.println("DO concentration compensated for salinity: " + this.salinity + " (ppt)");
                    if (this.eorp) {
                        mycatf.println("Saturation computed at elevation: " + this.ep + " (meter)");
                    } else {
                        mycatf.println("Saturation computed at pressure: " + this.ep + " (mbar)");
                    }
                    mycatf.println("");
                    for (i = 0; i < ChannelArray.size(); ++i) {
                        ((Channel)ChannelArray.get((int)i)).currentCatFile = mycatf;
                    }
                    for (i = 0; i < ChannelArray.size(); ++i) {
                        ((Channel)ChannelArray.get(i)).printChannelName();
                    }
                    mycatf.println("");
                    for (i = 0; i < ChannelArray.size(); ++i) {
                        ((Channel)ChannelArray.get(i)).printChannelUnit();
                    }
                    mycatf.println("");
                }
                while (measurementFile.readScan() != -1) {
                    for (i = 0; i < ChannelArray.size(); ++i) {
                        ((Channel)ChannelArray.get(i)).printEU(Locale.US);
                    }
                    mycatf.println("");
                }
                measurementFile.close();
                continue;
            }
            catch (IOException e) {
                throw new IOException("File: " + (String)measurementFileNames[fileindex] + "\n" + e);
            }
            catch (NumberFormatException n) {
                throw new NumberFormatException("File: " + (String)measurementFileNames[fileindex] + "\n" + n);
            }
        }
        mycatf.close();
        this.updateProgress(0);
    }

    private void updateProgress(final int value) {
        Runnable dorun = new Runnable(){

            public void run() {
                Concatenator.this.mpb.setValue(value);
            }
        };
        try {
            SwingUtilities.invokeLater(dorun);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isMeasurementFile(String filename) {
        return filename.charAt(4) == '-' && filename.charAt(7) == '-' && filename.charAt(17) == 'Z' && filename.endsWith(".txt");
    }
}

