/*
 * Decompiled with CFR 0.152.
 */
package com.pme.channel;

import com.pme.calc.ConcO2GG;
import com.pme.channel.Channel;
import java.io.IOException;
import java.util.Locale;

public class DOSat
extends Channel {
    private double barometricPressure;
    private double salinity;

    public DOSat(double barometricpressure, double salinity) {
        super("Dissolved Oxygen Saturation", "(%)");
        this.barometricPressure = barometricpressure;
        this.salinity = salinity;
    }

    public void printEU(Locale l) throws IOException {
        double compensatedDO = this.currentMeasurementFile.DO * ConcO2GG.SalinityFactor(this.currentMeasurementFile.T, this.salinity);
        double saturation = compensatedDO / ConcO2GG.DOConcMg(this.currentMeasurementFile.T, this.barometricPressure, this.salinity) * 100.0;
        String myformatstring = null;
        myformatstring = this.ChannelName.length() > 12 ? "%1$" + this.ChannelName.length() + "." + 6 + "f" : "%1$12.6f";
        String myprintstring = String.format(l, myformatstring, saturation);
        this.printColumn(myprintstring);
    }
}

