C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
C                                                                      %
C Copyright (C) 1998, The Board of Trustees of the Leland Stanford     %
C Junior University.  All rights reserved.                             %
C                                                                      %
C The programs in GSLIB are distributed in the hope that they will be  %
C useful, but WITHOUT ANY WARRANTY.  No author or distributor accepts  %
C responsibility to anyone for the consequences of using them or for   %
C whether they serve any particular purpose or work at all, unless he  %
C says so in writing.  Everyone is granted permission to copy, modify  %
C and redistribute the programs in GSLIB, but only under the condition %
C that this notice and the above copyright notice remain intact.       %
C                                                                      %
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c-----------------------------------------------------------
c     
c     P-field simulation using FFT
c     Author: Zhanjun Ying, 12-30-98
c     This subroutine is based on  GSLIB program PFSIM and SPECSIM.
c     It generates  an unconditonal random p-field using FFT and 
c     uses the p-field to sample the ccdfs  which are  generated by ik3d.   
c-----------------------------------------------------------
      subroutine pfsimfft

      include 'iksim.inc'
      parameter (MAXROTZ = MAXCUT+1) 
      real covline(2*MAXCLSX*MAXCLSY*MAXCLSZ)
      real ccl(MAXCUT)
      real*8 rotmatz(MAXROTZ,3,3)
      real sim(MAXX*MAXY*MAXZ)
      data lsimoutfl/26/
      data lsimdbgfl/27/

c     
c     Open the output file and write a header:
c     
      open(lsimoutfl,file=simoutfl,status='UNKNOWN')
      write(lsimoutfl,200)
 200  format('Simulation using p-field algorithm with FFT',/,'1',
     +     /,'value')

      open(lsimdbgfl,file=simdbgfl,status='UNKNOWN')
      write(lsimdbgfl,210)
 210  format('Random field generated by FFT',/,'1',
     +     /,'random field (Gaussian)')

c     
      
      write(*,*) 
      write(*,*) 'Working on simulation ...'
      write(*,*)

c     Set the size to the nearest powers of two

      nclsx=itwopower(nx)
      nclsy=itwopower(ny)
      nclsz=itwopower(nz)

c     make sure the dimension of array is big enough

      if((nclsx+1).gt.MAXCLSX .or. (nclsy+1).gt.MAXCLSY
     +                        .or. (nclsz+1).gt.MAXCLSZ) then
         write(*,*) 'Error: MAXCLSX, MAXCLSY or MAXCLSZ is too small'
         write(*,*) '       Modify iksim.inc file'
         stop
      end if

c     Initialize the p 
      do i=1,2000
         p = acorni(idum)
      end do

c     Setup the covariance table

      do is=1,nstz(1)
         call setrot(ang1z(is),ang2z(is),ang3z(is),
     +        anis1z(is),anis2z(is),is,MAXROTZ,rotmatz)
      end do

      call cova3(0.0,0.0,0.0,0.0,0.0,0.0,1,nstz,MAXNST,c0z,itz,
     +     ccz,aaz,1,MAXROTZ,rotmatz,cmax,maxcov)

      do k=-nclsz/2, nclsz/2
         do j =-nclsy/2, nclsy/2
            do i =-nclsx/2, nclsx/2
               xx = 1.0*i
               yy = 1.0*j
               zz = 1.0*k
               call cova3(0.0,0.0,0.0,xx,yy,zz,1,nstz,MAXNST,c0z,
     +              itz,ccz,aaz, 1,MAXROTZ,rotmatz,cmax,cov)
               
               covmap(1,i+nclsx/2+1,j+nclsy/2+1,k+nclsz/2+1) = cov
               covmap(2,i+nclsx/2+1,j+nclsy/2+1,k+nclsz/2+1) = 0.0
            end do
         end do
      end do
      
c     Shift the covariance table 
      
      if(nclsz.eq.1) then
         itmp = 1
      else
         itmp = nclsz +1
      endif

      call fftshift(covmap,nclsx+1,nclsy+1,itmp)

c     FFT the covariance table


      do k=1, nclsz
         do j=1, nclsy
            do i=1, nclsx
               ind = i + (j-1)*nclsx + (k-1)*nclsx*nclsy
               covline(2*ind-1) = covmap(1,i,j,k)
               covline(2*ind) = covmap(2,i,j,k)
            end do
         end do
      end do

      nn(1) = nclsx
      nn(2) = nclsy
      nn(3) = nclsz

      if(nclsz.eq.0) then
         call fourn(covline,nn,2,1)
      else
         call fourn(covline,nn,3,1)
      endif

      if(nclsz.eq.0) itmp = 1
      if(nclsz.gt.0) itmp = nclsz
      sum = 0.0
      do k=1, itmp
         do j =1, nclsy
            do i =1, nclsx
               ind = i+ (j-1)*nclsx +(k-1)*nclsx*nclsy
               covmap(1,i,j,k) = covline(2*ind-1)
               covmap(2,i,j,k) = 0.0
               sum = sum + covmap(1,i,j,k)
            end do
         end do
      end do


c     Calculate the mode of the spectrum

      do k =1, nclsz
         do j=1, nclsy
            do i =1, nclsx
               if(covmap(1,i,j,k).lt.1.0e-5) then
                  covmap(1,i,j,k)=0.0
               else
                  covmap(1, i,j,k) = sqrt(covmap(1, i,j,k))
               endif
            end do
         end do
      end do

c     Loop over all simulations

      do isim=1,nsim

c     Generate the phase and smooth it.


         do k =1, nclsz
            do j=1, nclsy
               do i=1, nclsx
                  p = acorni(idum)
                  reap = cos(p*2.0*PI)
                  rimg = sin(p*2.0*PI)
                  if((i.eq.1.and.j.eq.1.and.k.eq.1).or.
     +                 (i.eq.nclsx/2+1.and.j.eq.1.and.k.eq.1).or.
     +                 (i.eq.1.and.j.eq.nclsy/2+1.and.k.eq.1).or.
     +                 (i.eq.nclsx/2+1.and.j.eq.nclsy/2+1.and.k.eq.1)
     +                 .or.
     +                 (i.eq.1.and.j.eq.1.and.k.eq.nclsz/2+1).or.
     +                 (i.eq.nclsx/2+1.and.j.eq.1.and.k.eq.nclsz/2+1)
     +                 .or.
     +                 (i.eq.1.and.j.eq.nclsy/2+1.and.k.eq.nclsz/2+1)
     +                 .or.
     +                 (i.eq.nclsx/2+1.and.j.eq.nclsy/2+1
     +                 .and.k.eq.nclsz/2+1))       then
                     phase(2,i,j,k) = 0.0
                     phase(1,i,j,k) = 1.0
                  else
                     phase(1,i,j,k) = reap
                     phase(2,i,j,k) = rimg        
                  endif
               end do
            end do
         end do
         
         call fillsmth(phase,nclsx, nclsy, nclsz)
         
         
c     Calculate the coefficient array
         
         do k=1, nclsz
            do j=1, nclsy
               do i=1,nclsx
                  ind = i + (j-1)*nclsx + (k-1)*nclsx*nclsy
                  coef(1,i,j,k) = covmap(1,i,j,k)*phase(1,i,j,k)
                  coef(2,i,j,k) = covmap(1,i,j,k)*phase(2,i,j,k)
                  coefarray(2*ind-1) = coef(1,i,j,k)
                  coefarray(2*ind) = coef(2,i,j,k)
               end do
            end do
         end do

c     Do inverse FFT
         
         if(nclsz.gt.1) then
            call fourn(coefarray, nn, 3, -1)
         else
            call fourn(coefarray, nn, 2, -1)
         endif

c     Normalize the coefarray. The data we need is stored in coef(1,i,j,k).
         
         do k=1,nclsz
            do j= 1,nclsy
               do i=1, nclsx
                  ind = i+(j-1)*nclsx + (k-1)*nclsx*nclsy
                  coef(1,i,j,k) = coefarray(2*ind-1)
     +                 /sqrt(1.0*nclsx*nclsy*nclsz)
                  coef(2,i,j,k) = coefarray(2*ind)
     +                 /sqrt(1.0*nclsx*nclsy*nclsz)
               end do
            end do
         end do

c     Sample the pass matrix using the p-field stored in coef(1,i,j,k).
c     Notice the data in coef(1,i,j,k) is a Gauss distribution, hence
c     should be transformed to U(0,1).
         
         index=0
         do k=1,nz
            do j=1,ny
               do i=1,nx
                  index=index+1
                  pval=gcum(coef(1,i,nclsy+1-j,nclsz+1-k))
                  
c     get ccdf from pass() matrix
                  ccl(1) = pass(index, 1)
                  do icut=2,ncut
                     if(ivtype.eq.0) then
c     categorical variable. Convert the cpdf in pass() into a ccdf.
                        ccl(icut) = pass(index,icut) + ccl(icut-1)
                     else
                        ccl(icut) = pass(index,icut)
                     end if
                  end do


c     If the ccdf is unestimated, leave the node unsimulated
                  if(ccl(ncut).lt.-0.1) then
                     sim(index)=UNEST
                  else 
c     Simulate the node
                     if(ivtype.eq.0) then
c     In case of categorical varible
                        do icut=1,ncut
                           jcut = icut
                           if(pval.le.ccl(icut)) then
                              jcut = icut
                              go to 3
                           end if
                        end do
 3                      sim(index) = thres(jcut)
c     In case of continuous variable
                     else
                        sim(index) = -1.0
                        call beyond(1,ncut,thres,ccl,ncut,thres,gcdf,
     +                       zmin,zmax,ltail,ltpar,middle,mpar,utail,
     +                       utpar, sim(index),pval,ierr)
                        if(ierr.ne.0) then
                           write(*,*) 'ERROR: ',ierr,' continuing'
                        end if
                     end if
                  end if

c     If the node has a  closest hard datum, reset to the hard datum
                  if(closestData(index).ne.0 .and. 
     +                 hardData(closestData(index)).ne.MISSVALUE) 
     +                 sim(index)=hardData(closestData(index))

c     Write out the simulation result
                  write(lsimoutfl,'(f12.4)') sim(index)  

c     Write out debug info--the random field        
                  if(simidbg.ge.3) then
                     write(lsimdbgfl,'(f12.4)')
     +                    coef(1,i,nclsy+1-j,nclsz+1-k) 
                  end if
c     finished simulating one node.                
               end do
            end do
         end do
         
  
c     Finished one realization. Looped over all realizations
      end do
c     
c     Finished simulation part
      write(*,*)
      write(*,*) 'Simulation finished'
      write(*,*)
c     
c 
      close(lsimoutfl)
      close(lsimdbgfl)
      return
      end
      
c --------------------------------------------------------------------
c
c     Function itwopower(n)
c
c     It accepts an integer and returns the nearest integer
c     which is the power of two
c
c     input:  n
c     output: an integer which is power of two
c     author: zhanjun Ying
c ---------------------------------------------------------------------
      integer function itwopower(n)
      
      integer n
      real tmp
      
      tmp= log(1.0*n)/log(2.0)
      if(tmp.eq.INT(tmp) ) then
         itwopower=n
      else 
         it=INT(tmp)+1
         itwopower=INT(2**it)
      end if
      return
      end
      
c---------------------------------------------------------------
c
c     subroutine fillsmth(smthmap, nx,ny,nz)
c
c     From Tingting Yao's program SPECSIM
c
c--------------------------------------------------------------
      
      subroutine fillsmth(smthmap, nx,ny,nz)

      parameter (MAXX=513, MAXY=513, MAXZ=2)        
      real smthmap(2,MAXX, MAXY, MAXZ),fillspec(2,MAXX,MAXY,MAXZ)

      if(nx.gt.MAXX .or. ny.gt.MAXY .or. nz.gt.MAXZ) then
         write(*,*) 'Error: In file pfsimfft.f, subroutine fillsmth: '
         write(*,*) 'nx, ny, or nz is larger than MAXX, MAXY or MAXZ'
         write(*,*) 'nx = ', nx, 'ny = ', ny,  'nz = ', nz
         stop
      end if

      n1 =nz
      n2 =ny
      n3 =nx

      do 5 ilev=1,n1
         do 5 jrow = 1, n2
            do 5 kcol =1, n3
               fillspec(1,kcol, jrow, ilev)=
     +              smthmap(1,kcol, jrow, ilev)
               fillspec(2,kcol, jrow, ilev)=
     +              smthmap(2,kcol, jrow, ilev)
 5          continue

c     Fill up level 1 and level n1/2+1

            do 10 kcol = n3/2+2,n3
               fillspec(1,kcol,1,1) = smthmap(1,n3+2-kcol,1,1)
               fillspec(2,kcol,1,1) = -smthmap(2,n3+2-kcol,1,1)
               fillspec(1,kcol,n2/2+1,1)=
     +              smthmap(1,n3+2-kcol, n2/2+1,1)
               fillspec(2,kcol,n2/2+1,1)=
     +              -smthmap(2,n3+2-kcol, n2/2+1,1)
               fillspec(1,kcol,1,n1/2+1) = smthmap(1,n3+2-kcol,1,n1/2+1)
               fillspec(2,kcol,1,n1/2+1)=-smthmap(2,n3+2-kcol,1,n1/2+1)
               fillspec(1,kcol,n2/2+1,n1/2+1) =
     +              smthmap(1,n3+2-kcol, n2/2+1,n1/2+1)
               fillspec(2,kcol,n2/2+1,n1/2+1) =
     +              -smthmap(2,n3+2-kcol, n2/2+1,n1/2+1)
 10         continue

            
            do 20 jrow = n2/2+2, n2
               fillspec(1,1,jrow,1) =
     +              smthmap(1,1,n2+2-jrow,1) 
               fillspec(2,1,jrow,1) =
     +              -smthmap(2,1,n2+2-jrow,1)
               fillspec(1,n3/2+1,jrow,1) =
     +              smthmap(1,n3/2+1,n2+2-jrow,1)
               fillspec(2,n3/2+1,jrow,1) =
     +              -smthmap(2,n3/2+1,n2+2-jrow,1)
               fillspec(1,1,jrow,n1/2+1) =
     +              smthmap(1,1,n2+2-jrow,n1/2+1)
               fillspec(2,1,jrow,n1/2+1) =
     +              -smthmap(2,1,n2+2-jrow,n1/2+1)
               fillspec(1,n3/2+1,jrow,n1/2+1) = 
     +              smthmap(1,n3/2+1,n2+2-jrow,n1/2+1)
               fillspec(2,n3/2+1,jrow,n1/2+1) =
     +              -smthmap(2,n3/2+1,n2+2-jrow,n1/2+1)
 20         continue

            do 25 kcol = n3/2+2, n3
               fillspec(1,kcol,1,1) =
     +              smthmap(1,n3+2-kcol,1,1)
               fillspec(2,kcol,1,1) =
     +              -smthmap(2,n3+2-kcol,1,1)
               fillspec(1,kcol,n2/2+1, 1) =
     +              smthmap(1,n3+2-kcol,n2/2+1,1)
               fillspec(2,kcol,n2/2+1,1) =
     +              -smthmap(2,n3+2-kcol,n2/2+1,1)
               fillspec(1,kcol,1,n1/2+1) =
     +              smthmap(1,n3+2-kcol,1,n1/2+1)
               fillspec(2,kcol,1,n1/2+1) =
     +              -smthmap(2,n3+2-kcol,1,n1/2+1)
               fillspec(1,kcol,n2/2+1,n1/2+1) =
     +              smthmap(1,n3+2-kcol,n2/2+1,n1/2+1)
               fillspec(2,kcol,n2/2+1,n1/2+1) =
     +              -smthmap(2,n3+2-kcol,n2/2+1,n1/2+1)
 25         continue

            do 30 jrow =n2/2+2,n2
               do 40 kcol = 2, n3/2
                  fillspec(1,kcol, jrow, 1) = 
     +                 smthmap(1,n3+2-kcol, n2+2-jrow,1)
                  fillspec(2,kcol, jrow, 1) =
     +                 -smthmap(2,n3+2-kcol, n2+2-jrow,1)
                  fillspec(1,kcol, jrow, n1/2+1) =
     +                 smthmap(1,n3+2-kcol, n2+2-jrow,n1/2+1)
                  fillspec(2,kcol, jrow, n1/2+1) =
     +                 -smthmap(2,n3+2-kcol, n2+2-jrow,n1/2+1)
 40            continue
               do 50 kcol = n3/2+2, n3
                  fillspec(1,kcol, jrow,1) = 
     +                 smthmap(1,n3+2-kcol, n2+2-jrow, 1)
                  fillspec(2,kcol, jrow,1) =
     +                 -smthmap(2,n3+2-kcol, n2+2-jrow, 1)
                  fillspec(1,kcol, jrow,n1/2+1) = 
     +                 smthmap(1,n3+2-kcol, n2+2-jrow, n1/2+1)
                  fillspec(2,kcol, jrow,n1/2+1) =
     +                 -smthmap(2,n3+2-kcol, n2+2-jrow, n1/2+1)
 50            continue
 30         continue

c     Fill up level n1/2+2, n1

            do 60 ilev = n1/2+2, n1
               fillspec(1,1,1,ilev) = 
     +              smthmap(1,1,1, n1+2-ilev)
               fillspec(2,1,1,ilev) =
     +              -smthmap(2,1,1, n1+2-ilev)
               fillspec(1,n3/2+1,1,ilev) = 
     +              smthmap(1,n3/2+1,1,n1+2-ilev)
               fillspec(2,n3/2+1,1,ilev) =
     +              -smthmap(2,n3/2+1,1,n1+2-ilev)
               fillspec(1,1,n2/2+1,ilev) = 
     +              smthmap(1,1, n2/2+1,n1+2-ilev)
               fillspec(2,1,n2/2+1,ilev) =
     +              -smthmap(2,1, n2/2+1,n1+2-ilev)
               fillspec(1,n3/2+1,n2/2+1, ilev) =
     +              smthmap(1,n3/2+1,n2/2+1, n1+2-ilev)
               fillspec(2,n3/2+1,n2/2+1, ilev) =
     +              -smthmap(2,n3/2+1,n2/2+1, n1+2-ilev)
               do 70 kcol=2, n3/2
                  fillspec(1,kcol,1, ilev) =
     +                 smthmap(1,n3+2-kcol,1,n1+2-ilev)
                  fillspec(2,kcol,1, ilev) =
     +                 -smthmap(2,n3+2-kcol,1,n1+2-ilev)
                  fillspec(1,kcol,n2/2+1, ilev)=
     +                 smthmap(1,n3+2-kcol,n2/2+1,n1+2-ilev)
                  fillspec(2,kcol,n2/2+1, ilev)=
     +                 -smthmap(2,n3+2-kcol,n2/2+1,n1+2-ilev)
                  do 80 jrow=2,n2/2
                     fillspec(1,kcol, jrow, ilev) = 
     +                    smthmap(1,n3+2-kcol,n2+2-jrow, n1+2-ilev)
                     fillspec(2,kcol, jrow, ilev) =
     +                    - smthmap(2,n3+2-kcol,n2+2-jrow, n1+2-ilev)
 80               continue
                  do 90 jrow =n2/2+2, n2
                     fillspec(1,kcol, jrow, ilev) = 
     +                    smthmap(1,n3+2-kcol,n2+2-jrow, n1+2-ilev)
                     fillspec(2,kcol, jrow, ilev) =
     +                    - smthmap(2,n3+2-kcol,n2+2-jrow, n1+2-ilev)
 90               continue
 70            continue

               do 100 kcol=n3/2+2, n3
                  fillspec(1,kcol,1, ilev) = 
     +                 smthmap(1,n3+2-kcol,1,n1+2-ilev) 
                  fillspec(2,kcol,1, ilev) =
     +                 -smthmap(2,n3+2-kcol,1,n1+2-ilev)
                  fillspec(1,kcol,n2/2+1, ilev)=
     +                 smthmap(1,n3+2-kcol,n2/2+1,n1+2-ilev)
                  fillspec(2,kcol,n2/2+1, ilev)=
     +                 -smthmap(2,n3+2-kcol,n2/2+1,n1+2-ilev)
                  do 110 jrow=2,n2/2
                     fillspec(1,kcol, jrow, ilev) = 
     +                    smthmap(1,n3+2-kcol,n2+2-jrow, n1+2-ilev)
                     fillspec(2,kcol, jrow, ilev) =
     +                    -smthmap(2,n3+2-kcol,n2+2-jrow, n1+2-ilev)
 110              continue
                  do 120 jrow =n2/2+2, n2
                     fillspec(1, kcol, jrow, ilev) = 
     +                    smthmap(1,n3+2-kcol,n2+2-jrow, n1+2-ilev)
                     fillspec(2, kcol, jrow, ilev) =
     +                    -smthmap(2,n3+2-kcol,n2+2-jrow, n1+2-ilev)
 120              continue
 100           continue

               do 130 jrow=2, n2/2
                  fillspec(1,1,jrow,ilev) =
     +                 smthmap(1,1,n2+2-jrow, n1+2-ilev)
                  fillspec(2,1,jrow,ilev) =
     +                 -smthmap(2,1,n2+2-jrow, n1+2-ilev)
                  fillspec(1,n3/2+1, jrow,ilev) =
     +                 smthmap(1,n3/2+1, n2+2-jrow, n1+2-ilev)
                  fillspec(2,n3/2+1, jrow,ilev) =
     +                 -smthmap(2,n3/2+1, n2+2-jrow, n1+2-ilev)
 130           continue

               do 140 jrow= n2/2+2, n2
                  fillspec(1,1,jrow,ilev) =
     +                 smthmap(1,1,n2+2-jrow, n1+2-ilev)
                  fillspec(2,1,jrow,ilev) =
     +                 -smthmap(2,1,n2+2-jrow, n1+2-ilev)
                  fillspec(1,n3/2+1, jrow,ilev) =
     +                 smthmap(1,n3/2+1, n2+2-jrow, n1+2-ilev)
                  fillspec(2,n3/2+1, jrow,ilev) =
     +                 -smthmap(2,n3/2+1, n2+2-jrow, n1+2-ilev)
 140           continue


 60         continue

            do 150 ilev = 1, n1
               do 150 jrow = 1, n2
                  do 150 kcol = 1, n3
                     smthmap(1,kcol, jrow, ilev)=
     +                    fillspec(1,kcol, jrow, ilev)
                     smthmap(2,kcol, jrow, ilev)=
     +                    fillspec(2,kcol, jrow, ilev)
 150              continue

                  return 
                  end                  
      
c---------------------------------------------------------------
c
c     subroutine fftshift(covmap, nx,ny,nz)
c
c     From Tingting Yao's program SPECSIM
c
c--------------------------------------------------------------

      subroutine fftshift(covmap, nx,ny,nz)
      
      parameter (MAXX=513, MAXY=513, MAXZ=2)
      real covmap(2,MAXX, MAXY, MAXZ),shiftmap(2,MAXX,MAXY,MAXZ)
      
      if(nx.gt.MAXX .or. ny.gt.MAXY .or. nz.gt.MAXZ) then
         write(*,*) 'Error: In file pfsimfft.f, subroutine fillshift: '
         write(*,*) 'nx, ny, or nz is larger than MAXX, MAXY or MAXZ'
         write(*,*) 'nx = ', nx, 'ny = ', ny,  'nz = ', nz
         stop
      end if

      n1 = nz
      n2 = ny
      n3 = nx

c     Fill up upper left back

      if(n1.eq.1) then
         nnz = 1
      else
         nnz = n1/2+1
      endif

c     Fill up upper left back

         do 20 ilev=1, nnz
            do 20 jrow=1, n2/2+1
               do 20 kcol = 1, n3/2+1
                  shiftmap(1,kcol,jrow,ilev) =
     +               covmap(1,n3/2+kcol, n2/2+2-jrow, n1/2+2-ilev)
                  shiftmap(2,kcol,jrow,ilev) =
     +               covmap(2,n3/2+kcol, n2/2+2-jrow, n1/2+2-ilev)

20       continue

c     Fill up upper right back

       if(n1.eq.1) then
          nnz = 1
       else
          nnz = n1/2
       endif

         do 30 ilev=1,nnz 
            do 30 jrow = 1, n2/2
               do 30 kcol=n3/2+2, n3-1
                  shiftmap(1,kcol,jrow,ilev) =
     +               covmap(1,kcol-n3/2,n2/2+2-jrow,n1/2+2-ilev)
                  shiftmap(2,kcol,jrow,ilev) =
     +               covmap(2,kcol-n3/2,n2/2+2-jrow,n1/2+2-ilev)

30       continue



c     Fill up upper left front

       if(n1.eq.1) then
           nnz = 1
       else
           nnz = n1/2
       endif
        do 40 ilev=1, nnz 
           do 40 jrow = n2/2+2,n2-1
              do 40 kcol = 1, n3/2
                 shiftmap(1,kcol,jrow,ilev) =
     +              covmap(1,n3/2+kcol,n2+n2/2+1-jrow,n1/2+2-ilev)
                 shiftmap(2,kcol,jrow,ilev) =
     +              covmap(2,n3/2+kcol,n2+n2/2+1-jrow,n1/2+2-ilev)
40      continue

c     Fill up upper right front

        if(n1.eq.1) then
            nnz = 1
        else
            nnz = n1/2
        endif
        do 50 ilev=1, nnz 
           do 50 jrow = n2/2+1,n2-1
              do 50 kcol = n3/2+2, n3-1
                 shiftmap(1,kcol,jrow,ilev) =
     +              covmap(1,kcol-n3/2,n2+n2/2+1-jrow,n1/2+2-ilev)
                 shiftmap(2,kcol,jrow,ilev) =
     +              covmap(2,kcol-n3/2,n2+n2/2+1-jrow,n1/2+2-ilev)
50      continue

c     Insert in a part
        if(n1.eq.1) then
            nnz = 1
        else
            nnz = n1/2
        endif
        do 60 ilev=1,nnz 
           do 60 jrow = n2/2+2, n2-1
              shiftmap(1,n3/2+1, jrow, ilev) =
     +             covmap(1,1, n2+n2/2+1-jrow, n1/2+2-ilev)
              shiftmap(2,n3/2+1, n2/2+1, ilev) =
     +             covmap(2,1, n2+n2/2+1-jrow, n1/2+2-ilev)
60      continue

       if(n1.eq.1) go to 199

c     Fill in the central level

c     Fill up central right back
        do jrow = 2, n2/2
           do kcol = n3/2+2, n3-1
              shiftmap(1,kcol, jrow, n1/2+1) =
     +             covmap(1,kcol-n3/2, n2/2+2-jrow, 1)
              shiftmap(2,kcol, jrow, n1/2+1) =
     +             covmap(2,kcol-n3/2, n2/2+2-jrow, 1)
           end do
        end do
           do kcol = n3/2+2, n3-1
              shiftmap(1,kcol, 1, n1/2+1) =
     +             covmap(1,kcol-n3/2, n2/2+2-1, n1)
             shiftmap(2,kcol, 1, n1/2+1) =
     +             covmap(2,kcol-n3/2, n2/2+2-1, n1)
           end do

c     Fill up central left front
        do jrow = n2/2+2, n2-1
           do kcol = 1, n3/2
                 shiftmap(1,kcol,jrow,n1/2+1) =
     +              covmap(1,n3/2+kcol,n2+n2/2+1-jrow,n1)
                 shiftmap(2,kcol,jrow,n1/2+1) =
     +              covmap(2,n3/2+kcol,n2+n2/2+1-jrow,n1)
           end do
        end do

c     Fill up central right front
        do jrow =  n2/2+1,n2-1
           do kcol = n3/2+2, n3-1
                 shiftmap(1,kcol,jrow,n1/2+1) =
     +              covmap(1,kcol-n3/2,n2+n2/2+1-jrow,n1)
                 shiftmap(2,kcol,jrow,n1/2+1) =
     +              covmap(2,kcol-n3/2,n2+n2/2+1-jrow,n1)
           end do
        end do

c     Insert one part in the central level
        do jrow = n2/2+2, n2-1
           shiftmap(1,n3/2+1, jrow, n1/2+1) =
     +             covmap(1,1, n2+n2/2+1-jrow, n1)
           shiftmap(2,n3/2+1, jrow, n1/2+1) =
     +             covmap(2,1, n2+n2/2+1-jrow, n1)
        end do

c     Fill up the lower part:
 
c     Fill up lower left back

        do 70 ilev = n1/2+2, n1-1
           do 70 jrow =1, n2/2+1
              do 70 kcol=1, n3/2+1
                 shiftmap(1,kcol,jrow,ilev) =
     +              covmap(1,kcol+n3/2,n2/2+2-jrow,n1+n1/2+1-ilev)
                 shiftmap(2,kcol,jrow,ilev) =
     +              covmap(2,kcol+n3/2,n2/2+2-jrow,n1+n1/2+1-ilev)
70      continue

c     Correct three values
        do ilev = n1/2+2, n1-1
            shiftmap(1,n3/2+1,1,ilev ) =
     +         covmap(1,1,n2/2+1,n1+n1/2+1-ilev)
            shiftmap(2,n3/2+1,1,ilev ) =
     +         covmap(2,1,n2/2+1,n1+n1/2+1-ilev)
            shiftmap(1,1,n2/2+1,ilev ) =
     +         covmap(1,n3/2+1,n2, n1+n1/2+1-ilev)
            shiftmap(2,1,n2/2+1,ilev ) =
     +         covmap(2,n3/2+1,n2, n1+n1/2+1-ilev)
            shiftmap(1,n3/2+1, n2/2+1, ilev) =
     +         covmap(1, 1, n2, n1+n1/2+1-ilev)
            shiftmap(2,n3/2+1, n2/2+1, ilev) =
     +         covmap(2, 1, n2, n1+n1/2+1-ilev)
        end do

c     Fill up lower right back

        do 80 ilev = n1/2+2, n1-1
           do 80 jrow = 1, n2/2
              do 80 kcol = n3/2+2, n3-1
                 shiftmap(1,kcol,jrow,ilev) =
     +              covmap(1,kcol-n3/2,n2/2+2-jrow,n1+n1/2+1-ilev)
                 shiftmap(2,kcol,jrow,ilev) =
     +              covmap(2,kcol-n3/2,n2/2+2-jrow,n1+n1/2+1-ilev)
80      continue

c     Fill up lower left front

        do 90 ilev=n1/2+2, n1-1
           do 90 jrow = n2/2 +2, n2-1
              do 90 kcol = 1, n3/2
                 shiftmap(1,kcol, jrow,ilev) =
     +              covmap(1,kcol+n3/2, n2+n2/2+1-jrow, n1+n1/2+1-ilev)

                 shiftmap(2,kcol, jrow,ilev) =
     +              covmap(2,kcol+n3/2, n2+n2/2+1-jrow, n1+n1/2+1-ilev)
90      continue

c     Fill up lower right front

       do 100 ilev=n1/2+2, n1-1
          do 100 jrow =n2/2 +1, n2-1
             do 100 kcol = n3/2+2, n3-1
                shiftmap(1,kcol, jrow, ilev) =
     +             covmap(1,kcol-n3/2, n2+n2/2+1-jrow, n1+n1/2+1-ilev)
                shiftmap(2,kcol, jrow, ilev) =
     +             covmap(2,kcol-n3/2, n2+n2/2+1-jrow, n1+n1/2+1-ilev)
100    continue

c     Insert one part

       do 110 ilev = n1/2+2, n1-1
          do 110 jrow = n2/2+2, n2-1
             shiftmap(1,n3/2+1,jrow,ilev) =
     +          covmap(1,1, n2+n2/2+1-jrow, n1+n1/2+1-ilev)
             shiftmap(2,n3/2+1,jrow,ilev) =
     +          covmap(2,1, n2+n2/1+1-jrow, n1+n1/2+1-ilev)
110    continue

199      if(n1.eq.1) then
         nnz = 1
      else
         nnz = n1 -1
      endif

      do 120 ilev = 1, nnz
         do 120 jrow = 1, n2-1
            do 120 kcol = 1, n3-1
               covmap(1,kcol, jrow, ilev) =
     +            shiftmap(1,kcol, jrow, ilev)
               covmap(2,kcol, jrow, ilev) =
     +            shiftmap(2,kcol, jrow, ilev)
120   continue



      return
      end



c----------------------------------------------------------------
c
c     Subrountine fourn
c
c     From numerical Recipe.
c     N-Dimensional Fourier transform. NDIM=number of dimensions
c     NN=vector of size NDIM; NN(1)=no.of points along dimension 1, 
c     NN(2)=no.of points along dimension 2...etc.
c     
c----------------------------------------------------------------
      subroutine fourn(data,nn,ndim,isign)

      real*8 wr,wi,wpr,wpi,wtemp,theta
      dimension nn(ndim),data(*)
      ntot=1
      do 11 idim=1,ndim
         ntot=ntot*nn(idim)
 11   continue
      nprev=1
      do 18 idim=1,ndim
         n=nn(idim)
         nrem=ntot/(n*nprev)
         ip1=2*nprev
         ip2=ip1*n
         ip3=ip2*nrem
         i2rev=1


         do 14 i2=1,ip2,ip1
            if(i2.lt.i2rev)then
               do 13 i1=i2,i2+ip1-2,2
                  do 12 i3=i1,ip3,ip2
                     i3rev=i2rev+i3-i2
                     tempr=data(i3)
                     tempi=data(i3+1)
                     data(i3)=data(i3rev)
                     data(i3+1)=data(i3rev+1)
                     data(i3rev)=tempr
                     data(i3rev+1)=tempi
 12               continue
 13            continue
            endif

            ibit=ip2/2
 1          if((ibit.ge.ip1).and.(i2rev.gt.ibit)) then
               i2rev=i2rev-ibit
               ibit=ibit/2

               goto 1
            endif
            i2rev=i2rev+ibit
 14      continue
         ifp1=ip1
 2       if(ifp1.lt.ip2)then
            ifp2=2*ifp1
            theta=isign*6.28318530717959d0/(ifp2/ip1)
            wpr= -2.d0*dsin(0.5d0*theta)**2
            wpi=dsin(theta)
            wr=1.d0
            wi=0.d0

            do 17 i3=1,ifp1,ip1
               do 16 i1=i3,i3+ip1-2,2
                  do 15 i2=i1,ip3,ifp2
                     k1=i2
                     k2=k1+ifp1
                     tempr=sngl(wr)*data(k2)-sngl(wi)*data(k2+1)
                     tempi=sngl(wr)*data(k2+1)+sngl(wi)*data(k2)

                     data(k2)=data(k1)-tempr
                     data(k2+1)=data(k1+1)-tempi
                     data(k1)=data(k1)+tempr
                     data(k1+1)=data(k1+1)+tempi
 15               continue
 16            continue
               wtemp=wr
               wr=wr*wpr-wi*wpi+wr
               wi=wi*wpr+wtemp*wpi+wi
 17         continue
            ifp1=ifp2
            goto 2
         endif
         nprev=n*nprev
 18   continue
      return
      end
     



