C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
C                                                                      %
C Copyright (C) 1998, The Board of Trustees of the Leland Stanford     %
C Junior University.  All rights reserved.                             %
C                                                                      %
C The programs in GSLIB are distributed in the hope that they will be  %
C useful, but WITHOUT ANY WARRANTY.  No author or distributor accepts  %
C responsibility to anyone for the consequences of using them or for   %
C whether they serve any particular purpose or work at all, unless he  %
C says so in writing.  Everyone is granted permission to copy, modify  %
C and redistribute the programs in GSLIB, but only under the condition %
C that this notice and the above copyright notice remain intact.       %
C                                                                      %
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c-----------------------------------------------------------------------
c
c       Indicator Kriging and simulation  on a 3-D Rectangular Grid
c              *******************************************
c
c This file controls both the static dimensioning and allocates most of
c the storage in common blocks.
c
c   MAXSBX    maximum super block nodes in X direction
c   MAXSBY    maximum super block nodes in Y direction
c   MAXSBZ    maximum super block nodes in Z direction
c   MAXDAT    maximum number of data points
c   MAXSAM    maximum number of data points to use in one kriging system
c   MAXCUT    maximum number of IK cutoffs
c   MAXNST    maximum number of nested structures
c   MAXROT    maximum number of rotation matrices (MAXNST+1)
c   MAXCUT    maximum number of cutoffs to define a variogram model
c   MAXX      maximum number of nodes in X direction
c   MAXY      maximum number of nodes in Y direction
c   MAXZ      maximum number of nodes in Z direction
c   MAXCLSX   >= MAXX+1, and is power of two + 1
c   MAXCLSY   >= MAXY+1, and is power of two + 1
c   MAXCLSZ   >= MAXZ+1, and is power of two + 1
c   MAXLIM    maximum number of limits for envelope of non-zero p's
c-----------------------------------------------------------------------
c
c     User Adjustable Parameters:
c
      parameter(MAXDAT =  10000,
     +          MAXSAM =     64,
     +          MAXCUT =     11,
     +          MAXNST =      4,
     +          MAXX=     300, MAXY=     300, MAXZ=    10,
     +          MAXSBX =     21, MAXSBY =  21, MAXSBZ = 11,
     +          MAXCLSX =  513,  MAXCLSY =  513,  MAXCLSZ =   2,
     +          MAXLIM =    26, DEG2RAD=3.14159265/180.0,
     +          MISSVALUE = -999.0, UNEST = -999.0)
c     
c     Fixed Parameters:
c
      parameter(MAXSB=MAXSBX*MAXSBY*MAXSBZ,EPSLON=0.000001,
     +          MAXROT=MAXNST*MAXCUT+1,
     +          MAXEQ=MAXSAM+1,VERSION=1.000,
     +           NUMSCL=100,PI = 3.1415926)

c
c     Static Array Dimensioning:
c
      logical hasMissValue(MAXDAT)
      integer nisb(MAXSB),it(MAXCUT*MAXNST),nst(MAXCUT),nviol(MAXCUT),
     +        ixsbtosr(8*MAXSB),iysbtosr(8*MAXSB),izsbtosr(8*MAXSB),
     +        closestData(MAXX*MAXY*MAXZ)
      real    x(MAXDAT),y(MAXDAT),z(MAXDAT),  hardData(MAXDAT), 
     +         vr(MAXDAT,MAXCUT+1),
     +        sb(MAXDAT),tmp(MAXDAT),xa(MAXSAM),ya(MAXSAM),za(MAXSAM),
     +        vra(MAXSAM),sdis(MAXDAT),close(MAXDAT),actloc(MAXDAT),
     +        gcdf(MAXCUT),ccdf(MAXCUT),ccdfo(MAXCUT),
     +        aviol(MAXCUT),xviol(MAXCUT),
     +        thres(MAXCUT),c0(MAXCUT),cc(MAXCUT*MAXNST),
     +        aa(MAXCUT*MAXNST),ang1(MAXCUT*MAXNST),
     +        ang2(MAXCUT*MAXNST),ang3(MAXCUT*MAXNST),
     +        anis1(MAXCUT*MAXNST),anis2(MAXCUT*MAXNST),
     +        pass(MAXX*MAXY*MAXZ,MAXCUT)
      real*8  r(MAXEQ),s(MAXEQ),a(MAXEQ*MAXEQ),rotmat(MAXROT,3,3)
c
c     The data and other input variables:
c
      common /datcom/ nd,x,y,z,vr,nx,ny,nz,xmn,ymn,zmn,xsiz,ysiz,zsiz,
     +                ndmax,ndmin,radius,sang1,sang2,sang3,sanis1,
     +                sanis2,isrot,ivrot,mik,ktype,noct,ikidbg,
     +                ldbg,iout,lout,tmin,tmax,gcdf,ccdf,ccdfo,
     +                ivtype,nviol,aviol,xviol,koption,
     +                lin,
     +                pass,hasMissValue, hardData,closestData
c
c     The data for ik3d
c
      character ikoutfl*40, ikdbgfl*40
      common /ik3ddata/ ikoutfl,ikdbgfl

c
c     Search variables and data for kriging:
c
      common /srccom/ na,xa,ya,za,vra,sdis,close,actloc,
     +                ljack,ixlj,iylj,izlj,ivrlj,nvarij
c
c     Double Precision kriging arrays:
c
      common /krigmt/ r,s,a,rotmat
c
c     Variogram Parameters:
c
      common /vargdt/ ncut,thres,nst,c0,it,cc,aa,ang1,ang2,ang3,
     +                anis1,anis2

c
c     The data for postik
c

      integer ipostik,ietype,iprob,ipercentile,icondvar,idefault,
     +ltail,middle,utail,maxdis
      real zmin,zmax,parlim,parprob,ltpar,mpar,utpar
      character postoutfl*40

c     Declare the above data as common block

      common /postikdata/  ipostik,ietype,iprob,ipercentile,
     +icondvar,idefault,ltail,middle,utail,maxdis,
     +zmin,zmax,parlim,parprob,ltpar,mpar,utpar,
     +postoutfl

c
c Data for pfsimfft
c 

C     Declare data type
      character simoutfl*40, simdbgfl*40
      integer idosim,simidbg, nstz(1),itz(MAXNST), nsim,nn(3)
      real    c0z(1),ccz(MAXNST),
     +        aaz(MAXNST),ang1z(MAXNST),
     +        ang2z(MAXNST),ang3z(MAXNST),
     +        anis1z(MAXNST),anis2z(MAXNST),
     +        coefarray(2*MAXCLSX*MAXCLSY*MAXCLSZ),
     +        covmap(2,MAXCLSX,MAXCLSY,MAXCLSZ),
     +        phase(2,MAXCLSX,MAXCLSY,MAXCLSZ),
     +        coef(2,MAXCLSX,MAXCLSY,MAXCLSZ)
  
      common /pfsimdata/ simoutfl, simdbgfl,
     +        idosim,simidbg, nstz,itz,c0z,ccz,aaz,
     +        ang1z,ang2z,ang3z,anis1z,anis2z,
     +        nsim, nn, coefarray,covmap,
     +        phase, coef

c
c     ACORN parameters:
c
      parameter(KORDEI=12,MAXOP1=KORDEI+1,MAXINT=2**30)

c     The common block for function acorni
      common /iaco/   ixv(MAXOP1)

c data for trans
     
      character distin*40, transoutfl*40
      integer identhist, itarget, transivr, transiwt, wx, wy, wz
      real omega, variance(MAXX*MAXY*MAXZ)
      common /transdata/ distin, transoutfl,
     +      identhist, itarget, transivr, transiwt, wx, wy, wz,
     +      omega, variance
